/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Printer {
    private SessionFactoryImplementor factory;
    private static final Logger log = LoggerFactory.getLogger(Printer.class);

    public String toString(Object object, EntityMode entityMode) throws HibernateException {
        ClassMetadata classMetadata = this.factory.getClassMetadata(object.getClass());
        if (classMetadata == null) {
            return object.getClass().getName();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (classMetadata.hasIdentifierProperty()) {
            hashMap.put(classMetadata.getIdentifierPropertyName(), classMetadata.getIdentifierType().toLoggableString(classMetadata.getIdentifier(object, entityMode), this.factory));
        }
        Type[] typeArray = classMetadata.getPropertyTypes();
        String[] stringArray = classMetadata.getPropertyNames();
        Object[] objectArray = classMetadata.getPropertyValues(object, entityMode);
        for (int i = 0; i < typeArray.length; ++i) {
            if (stringArray[i].startsWith("_")) continue;
            String string = objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? objectArray[i].toString() : typeArray[i].toLoggableString(objectArray[i], this.factory);
            hashMap.put(stringArray[i], string);
        }
        return classMetadata.getEntityName() + ((Object)hashMap).toString();
    }

    public String toString(Type[] typeArray, Object[] objectArray) throws HibernateException {
        ArrayList<String> arrayList = new ArrayList<String>(typeArray.length * 5);
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i] == null) continue;
            arrayList.add(typeArray[i].toLoggableString(objectArray[i], this.factory));
        }
        return ((Object)arrayList).toString();
    }

    public String toString(Map map) throws HibernateException {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            TypedValue typedValue = (TypedValue)entry.getValue();
            hashMap.put(entry.getKey(), typedValue.getType().toLoggableString(typedValue.getValue(), this.factory));
        }
        return ((Object)hashMap).toString();
    }

    public void toString(Iterator iterator, EntityMode entityMode) throws HibernateException {
        if (!log.isDebugEnabled() || !iterator.hasNext()) {
            return;
        }
        log.debug("listing entities:");
        int n = 0;
        while (iterator.hasNext()) {
            if (n++ > 20) {
                log.debug("more......");
                break;
            }
            log.debug(this.toString(iterator.next(), entityMode));
        }
    }

    public Printer(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }
}

