/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class Dom4jAccessor
implements PropertyAccessor {
    private String nodeName;
    private Type propertyType;
    private final SessionFactoryImplementor factory;

    public Dom4jAccessor(String string, Type type, SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
        this.nodeName = string;
        this.propertyType = type;
    }

    public Getter getGetter(Class clazz, String string) throws PropertyNotFoundException {
        if (this.nodeName == null) {
            throw new MappingException("no node name for property: " + string);
        }
        if (".".equals(this.nodeName)) {
            return new TextGetter(this.propertyType, this.factory);
        }
        if (this.nodeName.indexOf(47) > -1) {
            return new ElementAttributeGetter(this.nodeName, this.propertyType, this.factory);
        }
        if (this.nodeName.indexOf(64) > -1) {
            return new AttributeGetter(this.nodeName, this.propertyType, this.factory);
        }
        return new ElementGetter(this.nodeName, this.propertyType, this.factory);
    }

    public Setter getSetter(Class clazz, String string) throws PropertyNotFoundException {
        if (this.nodeName == null) {
            throw new MappingException("no node name for property: " + string);
        }
        if (".".equals(this.nodeName)) {
            return new TextSetter(this.propertyType);
        }
        if (this.nodeName.indexOf(47) > -1) {
            return new ElementAttributeSetter(this.nodeName, this.propertyType);
        }
        if (this.nodeName.indexOf(64) > -1) {
            return new AttributeSetter(this.nodeName, this.propertyType);
        }
        return new ElementSetter(this.nodeName, this.propertyType);
    }

    public static class ElementAttributeSetter
    extends Dom4jSetter {
        private final String elementName;
        private final String attributeName;

        ElementAttributeSetter(String string, Type type) {
            super(type);
            this.elementName = string.substring(0, string.indexOf(47));
            this.attributeName = string.substring(string.indexOf(47) + 2);
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
            Element element = (Element)object;
            Element element2 = element.element(this.elementName);
            if (object2 == null) {
                if (element2 != null) {
                    element2.detach();
                }
            } else {
                Attribute attribute;
                if (element2 == null) {
                    element2 = element.addElement(this.elementName);
                    attribute = null;
                } else {
                    attribute = element2.attribute(this.attributeName);
                }
                if (attribute == null) {
                    element2.addAttribute(this.attributeName, "null");
                    attribute = element2.attribute(this.attributeName);
                }
                this.propertyType.setToXMLNode(attribute, object2, sessionFactoryImplementor);
            }
        }
    }

    public static class ElementSetter
    extends Dom4jSetter {
        private final String elementName;

        ElementSetter(String string, Type type) {
            super(type);
            this.elementName = string;
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
            if (object2 != CollectionType.UNFETCHED_COLLECTION) {
                Element element = (Element)object;
                Element element2 = element.element(this.elementName);
                if (element2 != null) {
                    element2.detach();
                }
                if (object2 != null) {
                    Element element3 = element.addElement(this.elementName);
                    this.propertyType.setToXMLNode(element3, object2, sessionFactoryImplementor);
                }
            }
        }
    }

    public static class AttributeSetter
    extends Dom4jSetter {
        private final String attributeName;

        AttributeSetter(String string, Type type) {
            super(type);
            this.attributeName = string.substring(1);
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
            Element element = (Element)object;
            Attribute attribute = element.attribute(this.attributeName);
            if (object2 == null) {
                if (attribute != null) {
                    attribute.detach();
                }
            } else {
                if (attribute == null) {
                    element.addAttribute(this.attributeName, "null");
                    attribute = element.attribute(this.attributeName);
                }
                this.propertyType.setToXMLNode(attribute, object2, sessionFactoryImplementor);
            }
        }
    }

    public static class TextSetter
    extends Dom4jSetter {
        TextSetter(Type type) {
            super(type);
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
            Element element = (Element)object;
            if (!this.propertyType.isXMLElement()) {
                if (object2 == null) {
                    element.setText(null);
                } else {
                    this.propertyType.setToXMLNode(element, object2, sessionFactoryImplementor);
                }
            }
        }
    }

    public static class ElementAttributeGetter
    extends Dom4jGetter {
        private final String elementName;
        private final String attributeName;

        ElementAttributeGetter(String string, Type type, SessionFactoryImplementor sessionFactoryImplementor) {
            super(type, sessionFactoryImplementor);
            this.elementName = string.substring(0, string.indexOf(47));
            this.attributeName = string.substring(string.indexOf(47) + 2);
        }

        public Object get(Object object) throws HibernateException {
            Element element = (Element)object;
            Element element2 = element.element(this.elementName);
            if (element2 == null) {
                return null;
            }
            Attribute attribute = element2.attribute(this.attributeName);
            if (attribute == null) {
                return null;
            }
            return this.propertyType.fromXMLNode(attribute, this.factory);
        }
    }

    public static class ElementGetter
    extends Dom4jGetter {
        private final String elementName;

        ElementGetter(String string, Type type, SessionFactoryImplementor sessionFactoryImplementor) {
            super(type, sessionFactoryImplementor);
            this.elementName = string;
        }

        public Object get(Object object) throws HibernateException {
            Element element = (Element)object;
            Element element2 = element.element(this.elementName);
            return element2 == null ? null : this.propertyType.fromXMLNode(element2, this.factory);
        }
    }

    public static class AttributeGetter
    extends Dom4jGetter {
        private final String attributeName;

        AttributeGetter(String string, Type type, SessionFactoryImplementor sessionFactoryImplementor) {
            super(type, sessionFactoryImplementor);
            this.attributeName = string.substring(1);
        }

        public Object get(Object object) throws HibernateException {
            Element element = (Element)object;
            Attribute attribute = element.attribute(this.attributeName);
            return attribute == null ? null : this.propertyType.fromXMLNode(attribute, this.factory);
        }
    }

    public static class TextGetter
    extends Dom4jGetter {
        TextGetter(Type type, SessionFactoryImplementor sessionFactoryImplementor) {
            super(type, sessionFactoryImplementor);
        }

        public Object get(Object object) throws HibernateException {
            Element element = (Element)object;
            return this.propertyType.fromXMLNode(element, this.factory);
        }
    }

    public static abstract class Dom4jSetter
    implements Setter {
        protected final Type propertyType;

        Dom4jSetter(Type type) {
            this.propertyType = type;
        }

        public String getMethodName() {
            return null;
        }

        public Method getMethod() {
            return null;
        }
    }

    public static abstract class Dom4jGetter
    implements Getter {
        protected final Type propertyType;
        protected final SessionFactoryImplementor factory;

        Dom4jGetter(Type type, SessionFactoryImplementor sessionFactoryImplementor) {
            this.propertyType = type;
            this.factory = sessionFactoryImplementor;
        }

        public Object getForInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
            return this.get(object);
        }

        public Class getReturnType() {
            return Object.class;
        }

        public Member getMember() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Method getMethod() {
            return null;
        }
    }
}

