/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class IndexPropertyAccessor
implements PropertyAccessor {
    private final String propertyName;
    private final String entityName;

    public IndexPropertyAccessor(String string, String string2) {
        this.propertyName = string.substring(string2.length() + 1);
        this.entityName = string2;
    }

    public Setter getSetter(Class clazz, String string) {
        return new IndexSetter();
    }

    public Getter getGetter(Class clazz, String string) {
        return new IndexGetter();
    }

    public class IndexGetter
    implements Getter {
        public Object getForInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
            if (sessionImplementor == null) {
                return BackrefPropertyAccessor.UNKNOWN;
            }
            return sessionImplementor.getPersistenceContext().getIndexInOwner(IndexPropertyAccessor.this.entityName, IndexPropertyAccessor.this.propertyName, object, map);
        }

        public Object get(Object object) {
            return BackrefPropertyAccessor.UNKNOWN;
        }

        public Member getMember() {
            return null;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class getReturnType() {
            return Object.class;
        }
    }

    public static final class IndexSetter
    implements Setter {
        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) {
        }
    }
}

