/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.SessionException;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.LazyInitializer;

public abstract class AbstractLazyInitializer
implements LazyInitializer {
    private String entityName;
    private Serializable id;
    private Object target;
    private boolean initialized;
    private boolean readOnly;
    private boolean unwrap;
    private transient SessionImplementor session;
    private Boolean readOnlyBeforeAttachedToSession;

    protected AbstractLazyInitializer() {
    }

    protected AbstractLazyInitializer(String string, Serializable serializable, SessionImplementor sessionImplementor) {
        this.entityName = string;
        this.id = serializable;
        if (sessionImplementor == null) {
            this.unsetSession();
        } else {
            this.setSession(sessionImplementor);
        }
    }

    public final String getEntityName() {
        return this.entityName;
    }

    public final Serializable getIdentifier() {
        return this.id;
    }

    public final void setIdentifier(Serializable serializable) {
        this.id = serializable;
    }

    public final boolean isUninitialized() {
        return !this.initialized;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final void setSession(SessionImplementor sessionImplementor) throws HibernateException {
        if (sessionImplementor != this.session) {
            if (sessionImplementor == null) {
                this.unsetSession();
            } else {
                if (this.isConnectedToSession()) {
                    throw new HibernateException("illegally attempted to associate a proxy with two open Sessions");
                }
                this.session = sessionImplementor;
                if (this.readOnlyBeforeAttachedToSession == null) {
                    EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(this.entityName);
                    this.setReadOnly(sessionImplementor.getPersistenceContext().isDefaultReadOnly() || !entityPersister.isMutable());
                } else {
                    this.setReadOnly(this.readOnlyBeforeAttachedToSession);
                    this.readOnlyBeforeAttachedToSession = null;
                }
            }
        }
    }

    private static EntityKey generateEntityKeyOrNull(Serializable serializable, SessionImplementor sessionImplementor, String string) {
        if (serializable == null || sessionImplementor == null || string == null) {
            return null;
        }
        return new EntityKey(serializable, sessionImplementor.getFactory().getEntityPersister(string), sessionImplementor.getEntityMode());
    }

    public final void unsetSession() {
        this.session = null;
        this.readOnly = false;
        this.readOnlyBeforeAttachedToSession = null;
    }

    public final void initialize() throws HibernateException {
        if (!this.initialized) {
            if (this.session == null) {
                throw new LazyInitializationException("could not initialize proxy - no Session");
            }
            if (!this.session.isOpen()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session was closed");
            }
            if (!this.session.isConnected()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session is disconnected");
            }
            this.target = this.session.immediateLoad(this.entityName, this.id);
            this.initialized = true;
            this.checkTargetState();
        } else {
            this.checkTargetState();
        }
    }

    private void checkTargetState() {
        if (!this.unwrap && this.target == null) {
            this.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityName, this.id);
        }
    }

    protected final boolean isConnectedToSession() {
        return this.getProxyOrNull() != null;
    }

    private Object getProxyOrNull() {
        EntityKey entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getIdentifier(), this.session, this.getEntityName());
        if (entityKey != null && this.session != null && this.session.isOpen()) {
            return this.session.getPersistenceContext().getProxy(entityKey);
        }
        return null;
    }

    public final Object getImplementation() {
        this.initialize();
        return this.target;
    }

    public final void setImplementation(Object object) {
        this.target = object;
        this.initialized = true;
    }

    public final Object getImplementation(SessionImplementor sessionImplementor) throws HibernateException {
        EntityKey entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getIdentifier(), sessionImplementor, this.getEntityName());
        return entityKey == null ? null : sessionImplementor.getPersistenceContext().getEntity(entityKey);
    }

    protected final Object getTarget() {
        return this.target;
    }

    public final boolean isReadOnlySettingAvailable() {
        return this.session != null && !this.session.isClosed();
    }

    private void errorIfReadOnlySettingNotAvailable() {
        if (this.session == null) {
            throw new TransientObjectException("Proxy is detached (i.e, session is null). The read-only/modifiable setting is only accessible when the proxy is associated with an open session.");
        }
        if (this.session.isClosed()) {
            throw new SessionException("Session is closed. The read-only/modifiable setting is only accessible when the proxy is associated with an open session.");
        }
    }

    public final boolean isReadOnly() {
        this.errorIfReadOnlySettingNotAvailable();
        return this.readOnly;
    }

    public final void setReadOnly(boolean bl) {
        this.errorIfReadOnlySettingNotAvailable();
        if (this.readOnly != bl) {
            EntityKey entityKey;
            EntityPersister entityPersister = this.session.getFactory().getEntityPersister(this.entityName);
            if (!entityPersister.isMutable() && !bl) {
                throw new IllegalStateException("cannot make proxies for immutable entities modifiable");
            }
            this.readOnly = bl;
            if (this.initialized && (entityKey = AbstractLazyInitializer.generateEntityKeyOrNull(this.getIdentifier(), this.session, this.getEntityName())) != null && this.session.getPersistenceContext().containsEntity(entityKey)) {
                this.session.getPersistenceContext().setReadOnly(this.target, bl);
            }
        }
    }

    protected final Boolean isReadOnlyBeforeAttachedToSession() {
        if (this.isReadOnlySettingAvailable()) {
            throw new IllegalStateException("Cannot call isReadOnlyBeforeAttachedToSession when isReadOnlySettingAvailable == true");
        }
        return this.readOnlyBeforeAttachedToSession;
    }

    final void setReadOnlyBeforeAttachedToSession(Boolean bl) {
        if (this.isReadOnlySettingAvailable()) {
            throw new IllegalStateException("Cannot call setReadOnlyBeforeAttachedToSession when isReadOnlySettingAvailable == true");
        }
        this.readOnlyBeforeAttachedToSession = bl;
    }

    public boolean isUnwrap() {
        return this.unwrap;
    }

    public void setUnwrap(boolean bl) {
        this.unwrap = bl;
    }
}

