/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.javassist;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.proxy.AbstractSerializableProxy;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.javassist.JavassistLazyInitializer;
import org.hibernate.type.CompositeType;

public final class SerializableProxy
extends AbstractSerializableProxy {
    private Class persistentClass;
    private Class[] interfaces;
    private Class getIdentifierMethodClass;
    private Class setIdentifierMethodClass;
    private String getIdentifierMethodName;
    private String setIdentifierMethodName;
    private Class[] setIdentifierMethodParams;
    private CompositeType componentIdType;

    public SerializableProxy() {
    }

    public SerializableProxy(String string, Class clazz, Class[] classArray, Serializable serializable, Boolean bl, Method method, Method method2, CompositeType compositeType) {
        super(string, serializable, bl);
        this.persistentClass = clazz;
        this.interfaces = classArray;
        if (method != null) {
            this.getIdentifierMethodClass = method.getDeclaringClass();
            this.getIdentifierMethodName = method.getName();
        }
        if (method2 != null) {
            this.setIdentifierMethodClass = method2.getDeclaringClass();
            this.setIdentifierMethodName = method2.getName();
            this.setIdentifierMethodParams = method2.getParameterTypes();
        }
        this.componentIdType = compositeType;
    }

    private Object readResolve() {
        try {
            HibernateProxy hibernateProxy = JavassistLazyInitializer.getProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifierMethodName == null ? null : this.getIdentifierMethodClass.getDeclaredMethod(this.getIdentifierMethodName, null), this.setIdentifierMethodName == null ? null : this.setIdentifierMethodClass.getDeclaredMethod(this.setIdentifierMethodName, this.setIdentifierMethodParams), this.componentIdType, this.getId(), null);
            this.setReadOnlyBeforeAttachedToSession((JavassistLazyInitializer)hibernateProxy.getHibernateLazyInitializer());
            return hibernateProxy;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new HibernateException("could not create proxy for entity: " + this.getEntityName(), noSuchMethodException);
        }
    }
}

