/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import java.security.Permission;
import java.util.StringTokenizer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JACCConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JACCConfiguration.class);
    private final PolicyConfiguration policyConfiguration;

    public JACCConfiguration(String string) throws HibernateException {
        try {
            this.policyConfiguration = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("JACC provider class not found", classNotFoundException);
        }
        catch (PolicyContextException policyContextException) {
            throw new HibernateException("policy context exception occurred", policyContextException);
        }
    }

    public void addPermission(String string, String string2, String string3) {
        if (string3.equals("*")) {
            string3 = "insert,read,update,delete";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            EJBMethodPermission eJBMethodPermission = new EJBMethodPermission(string2, string4, null, null);
            if (log.isDebugEnabled()) {
                log.debug("adding permission to role " + string + ": " + eJBMethodPermission);
            }
            try {
                this.policyConfiguration.addToRole(string, (Permission)eJBMethodPermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new HibernateException("policy context exception occurred", policyContextException);
            }
        }
    }
}

