/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import javax.security.jacc.EJBMethodPermission;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.secure.JACCPermissions;
import org.hibernate.secure.JACCSecurityListener;

public class JACCPreInsertEventListener
implements PreInsertEventListener,
Initializable,
JACCSecurityListener {
    private String contextID;

    public boolean onPreInsert(PreInsertEvent preInsertEvent) {
        EJBMethodPermission eJBMethodPermission = new EJBMethodPermission(preInsertEvent.getPersister().getEntityName(), "insert", null, null);
        JACCPermissions.checkPermission(preInsertEvent.getEntity().getClass(), this.contextID, eJBMethodPermission);
        return false;
    }

    public void initialize(Configuration configuration) {
        this.contextID = configuration.getProperty("hibernate.jacc_context_id");
    }
}

