/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.StringHelper;

public class ForUpdateFragment {
    private final StringBuffer aliases = new StringBuffer();
    private boolean isNowaitEnabled;
    private final Dialect dialect;
    private LockMode lockMode;
    private LockOptions lockOptions;

    public ForUpdateFragment(Dialect dialect) {
        this.dialect = dialect;
    }

    public ForUpdateFragment(Dialect dialect, LockOptions lockOptions, Map map) throws QueryException {
        this(dialect);
        Object object;
        Object object2 = null;
        Iterator iterator = lockOptions.getAliasLockIterator();
        this.lockOptions = lockOptions;
        if (!iterator.hasNext() && LockMode.READ.lessThan((LockMode)(object = lockOptions.getLockMode()))) {
            object2 = object;
            this.lockMode = object;
        }
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            LockMode lockMode = (LockMode)object.getValue();
            if (!LockMode.READ.lessThan(lockMode)) continue;
            String string = (String)object.getKey();
            if (dialect.forUpdateOfColumns()) {
                String[] stringArray = (String[])map.get(string);
                if (stringArray == null) {
                    throw new IllegalArgumentException("alias not found: " + string);
                }
                stringArray = StringHelper.qualify(string, stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addTableAlias(stringArray[i]);
                }
            } else {
                this.addTableAlias(string);
            }
            if (object2 != null && lockMode != object2) {
                throw new QueryException("mixed LockModes");
            }
            object2 = lockMode;
        }
        if (object2 == LockMode.UPGRADE_NOWAIT) {
            this.setNowaitEnabled(true);
        }
    }

    public ForUpdateFragment addTableAlias(String string) {
        if (this.aliases.length() > 0) {
            this.aliases.append(", ");
        }
        this.aliases.append(string);
        return this;
    }

    public String toFragmentString() {
        if (this.lockOptions != null) {
            return this.dialect.getForUpdateString(this.aliases.toString(), this.lockOptions);
        }
        if (this.aliases.length() == 0) {
            if (this.lockMode != null) {
                return this.dialect.getForUpdateString(this.lockMode);
            }
            return "";
        }
        return this.isNowaitEnabled ? this.dialect.getForUpdateNowaitString(this.aliases.toString()) : this.dialect.getForUpdateString(this.aliases.toString());
    }

    public ForUpdateFragment setNowaitEnabled(boolean bl) {
        this.isNowaitEnabled = bl;
        return this;
    }
}

