/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.util.StringHelper;

public class InFragment {
    public static final String NULL = "null";
    public static final String NOT_NULL = "not null";
    private String columnName;
    private List values = new ArrayList();

    public InFragment addValue(Object object) {
        this.values.add(object);
        return this;
    }

    public InFragment setColumn(String string) {
        this.columnName = string;
        return this;
    }

    public InFragment setColumn(String string, String string2) {
        this.columnName = StringHelper.qualify(string, string2);
        return this.setColumn(this.columnName);
    }

    public InFragment setFormula(String string, String string2) {
        this.columnName = StringHelper.replace(string2, "$PlaceHolder$", string);
        return this.setColumn(this.columnName);
    }

    public String toFragmentString() {
        if (this.values.size() == 0) {
            return "1=2";
        }
        StringBuffer stringBuffer = new StringBuffer(this.values.size() * 5);
        stringBuffer.append(this.columnName);
        if (this.values.size() > 1) {
            boolean bl = false;
            stringBuffer.append(" in (");
            for (Object e : this.values) {
                if (NULL.equals(e)) {
                    bl = true;
                    continue;
                }
                if (NOT_NULL.equals(e)) {
                    throw new IllegalArgumentException("not null makes no sense for in expression");
                }
                stringBuffer.append(e);
                stringBuffer.append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(')');
            if (bl) {
                stringBuffer.insert(0, " is null or ").insert(0, this.columnName).insert(0, '(').append(')');
            }
        } else {
            Object e = this.values.iterator().next();
            if (NULL.equals(e)) {
                stringBuffer.append(" is null");
            } else if (NOT_NULL.equals(e)) {
                stringBuffer.append(" is not null");
            } else {
                stringBuffer.append("=").append(e);
            }
        }
        return stringBuffer.toString();
    }
}

