/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.LiteralType;

public class Insert {
    private Dialect dialect;
    private String tableName;
    private String comment;
    private Map columns = new LinkedHashMap();

    public Insert(Dialect dialect) {
        this.dialect = dialect;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    public Insert setComment(String string) {
        this.comment = string;
        return this;
    }

    public Insert addColumn(String string) {
        return this.addColumn(string, "?");
    }

    public Insert addColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(stringArray[i]);
        }
        return this;
    }

    public Insert addColumns(String[] stringArray, boolean[] blArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            this.addColumn(stringArray[i]);
        }
        return this;
    }

    public Insert addColumns(String[] stringArray, boolean[] blArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            this.addColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public Insert addColumn(String string, String string2) {
        this.columns.put(string, string2);
        return this;
    }

    public Insert addColumn(String string, Object object, LiteralType literalType) throws Exception {
        return this.addColumn(string, literalType.objectToSQLString(object, this.dialect));
    }

    public Insert addIdentityColumn(String string) {
        String string2 = this.dialect.getIdentityInsertString();
        if (string2 != null) {
            this.addColumn(string, string2);
        }
        return this;
    }

    public Insert setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public String toStatementString() {
        StringBuffer stringBuffer = new StringBuffer(this.columns.size() * 15 + this.tableName.length() + 10);
        if (this.comment != null) {
            stringBuffer.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuffer.append("insert into ").append(this.tableName);
        if (this.columns.size() == 0) {
            stringBuffer.append(' ').append(this.dialect.getNoColumnsInsertString());
        } else {
            stringBuffer.append(" (");
            Iterator<Object> iterator = this.columns.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(") values (");
            iterator = this.columns.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }
}

