/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.LiteralType;

public class Update {
    private String tableName;
    private String versionColumnName;
    private String where;
    private String assignments;
    private String comment;
    private Map primaryKeyColumns = new LinkedHashMap();
    private Map columns = new LinkedHashMap();
    private Map whereColumns = new LinkedHashMap();
    private Dialect dialect;

    public Update(Dialect dialect) {
        this.dialect = dialect;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Update appendAssignmentFragment(String string) {
        this.assignments = this.assignments == null ? string : this.assignments + ", " + string;
        return this;
    }

    public Update setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public Update setPrimaryKeyColumnNames(String[] stringArray) {
        this.primaryKeyColumns.clear();
        this.addPrimaryKeyColumns(stringArray);
        return this;
    }

    public Update addPrimaryKeyColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPrimaryKeyColumn(stringArray[i], "?");
        }
        return this;
    }

    public Update addPrimaryKeyColumns(String[] stringArray, boolean[] blArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            this.addPrimaryKeyColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public Update addPrimaryKeyColumns(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPrimaryKeyColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public Update addPrimaryKeyColumn(String string, String string2) {
        this.primaryKeyColumns.put(string, string2);
        return this;
    }

    public Update setVersionColumnName(String string) {
        this.versionColumnName = string;
        return this;
    }

    public Update setComment(String string) {
        this.comment = string;
        return this;
    }

    public Update addColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(stringArray[i]);
        }
        return this;
    }

    public Update addColumns(String[] stringArray, boolean[] blArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            this.addColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public Update addColumns(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(stringArray[i], string);
        }
        return this;
    }

    public Update addColumn(String string) {
        return this.addColumn(string, "?");
    }

    public Update addColumn(String string, String string2) {
        this.columns.put(string, string2);
        return this;
    }

    public Update addColumn(String string, Object object, LiteralType literalType) throws Exception {
        return this.addColumn(string, literalType.objectToSQLString(object, this.dialect));
    }

    public Update addWhereColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addWhereColumn(stringArray[i]);
        }
        return this;
    }

    public Update addWhereColumns(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addWhereColumn(stringArray[i], string);
        }
        return this;
    }

    public Update addWhereColumn(String string) {
        return this.addWhereColumn(string, "=?");
    }

    public Update addWhereColumn(String string, String string2) {
        this.whereColumns.put(string, string2);
        return this;
    }

    public Update setWhere(String string) {
        this.where = string;
        return this;
    }

    public String toStatementString() {
        StringBuffer stringBuffer = new StringBuffer(this.columns.size() * 15 + this.tableName.length() + 10);
        if (this.comment != null) {
            stringBuffer.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuffer.append("update ").append(this.tableName).append(" set ");
        boolean bl = false;
        Iterator iterator = this.columns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey()).append('=').append(entry.getValue());
            if (iterator.hasNext()) {
                stringBuffer.append(", ");
            }
            bl = true;
        }
        if (this.assignments != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.assignments);
        }
        boolean bl2 = false;
        if (!this.primaryKeyColumns.isEmpty() || this.where != null || !this.whereColumns.isEmpty() || this.versionColumnName != null) {
            stringBuffer.append(" where ");
        }
        iterator = this.primaryKeyColumns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey()).append('=').append(entry.getValue());
            if (iterator.hasNext()) {
                stringBuffer.append(" and ");
            }
            bl2 = true;
        }
        if (this.where != null) {
            if (bl2) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(this.where);
            bl2 = true;
        }
        for (Map.Entry entry : this.whereColumns.entrySet()) {
            if (bl2) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(entry.getKey()).append(entry.getValue());
            bl2 = true;
        }
        if (this.versionColumnName != null) {
            if (bl2) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(this.versionColumnName).append("=?");
        }
        return stringBuffer.toString();
    }
}

