/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.CommonAST;
import antlr.TokenStream;
import antlr.collections.AST;
import java.util.ArrayList;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.sql.ordering.antlr.CollationSpecification;
import org.hibernate.sql.ordering.antlr.Factory;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentParser;
import org.hibernate.sql.ordering.antlr.OrderingSpecification;
import org.hibernate.sql.ordering.antlr.SortKey;
import org.hibernate.sql.ordering.antlr.SortSpecification;
import org.hibernate.sql.ordering.antlr.TranslationContext;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByFragmentParser
extends GeneratedOrderByFragmentParser {
    private static final Logger log = LoggerFactory.getLogger(OrderByFragmentParser.class);
    private final TranslationContext context;
    private int traceDepth = 0;

    public OrderByFragmentParser(TokenStream tokenStream, TranslationContext translationContext) {
        super(tokenStream);
        super.setASTFactory(new Factory());
        this.context = translationContext;
    }

    public void traceIn(String string) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        log.trace(string2 + string);
    }

    public void traceOut(String string) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        log.trace(string2 + string);
    }

    protected void trace(String string) {
        log.trace(string);
    }

    protected AST quotedIdentifier(AST aST) {
        return this.getASTFactory().create(17, "$PlaceHolder$." + this.context.getDialect().quote('`' + aST.getText() + '`'));
    }

    protected AST quotedString(AST aST) {
        return this.getASTFactory().create(17, this.context.getDialect().quote(aST.getText()));
    }

    protected boolean isFunctionName(AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null && "{param list}".equals(aST2.getText())) {
            return true;
        }
        SQLFunction sQLFunction = this.context.getSqlFunctionRegistry().findSQLFunction(aST.getText());
        if (sQLFunction == null) {
            return false;
        }
        return !sQLFunction.hasParenthesesIfNoArguments();
    }

    protected AST resolveFunction(AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            assert ("{param list}".equals(aST2.getText()));
            aST2 = aST2.getFirstChild();
        }
        String string = aST.getText();
        SQLFunction sQLFunction = this.context.getSqlFunctionRegistry().findSQLFunction(string);
        if (sQLFunction == null) {
            String string2 = string;
            if (aST2 != null) {
                string2 = string2 + '(';
                while (aST2 != null) {
                    string2 = string2 + aST2.getText();
                    if ((aST2 = aST2.getNextSibling()) == null) continue;
                    string2 = string2 + ", ";
                }
                string2 = string2 + ')';
            }
            return this.getASTFactory().create(17, string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (aST2 != null) {
            arrayList.add(aST2.getText());
            aST2 = aST2.getNextSibling();
        }
        String string3 = sQLFunction.render(null, arrayList, this.context.getSessionFactory());
        return this.getASTFactory().create(17, string3);
    }

    protected AST resolveIdent(AST aST) {
        String[] stringArray;
        String string = aST.getText();
        try {
            stringArray = this.context.getColumnMapper().map(string);
        }
        catch (Throwable throwable) {
            stringArray = null;
        }
        if (stringArray == null || stringArray.length == 0) {
            return this.getASTFactory().create(17, "$PlaceHolder$." + string);
        }
        if (stringArray.length == 1) {
            return this.getASTFactory().create(17, "$PlaceHolder$." + stringArray[0]);
        }
        AST aST2 = this.getASTFactory().create(10, "{ident list}");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = "$PlaceHolder$." + stringArray[i];
            aST2.addChild(this.getASTFactory().create(17, string2));
        }
        return aST2;
    }

    protected AST postProcessSortSpecification(AST aST) {
        assert (5 == aST.getType());
        SortSpecification sortSpecification = (SortSpecification)aST;
        SortKey sortKey = sortSpecification.getSortKey();
        if (10 == sortKey.getFirstChild().getType()) {
            AST aST2 = sortKey.getFirstChild();
            AST aST3 = aST2.getFirstChild();
            CommonAST commonAST = new CommonAST();
            do {
                commonAST.addChild(this.createSortSpecification(aST3, sortSpecification.getCollation(), sortSpecification.getOrdering()));
            } while ((aST3 = aST3.getNextSibling()) != null);
            aST = commonAST.getFirstChild();
        }
        return aST;
    }

    private SortSpecification createSortSpecification(AST aST, CollationSpecification collationSpecification, OrderingSpecification orderingSpecification) {
        AST aST2 = this.getASTFactory().create(5, "{{sort specification}}");
        AST aST3 = this.getASTFactory().create(7, "{{sort key}}");
        AST aST4 = this.getASTFactory().create(aST.getType(), aST.getText());
        aST3.setFirstChild(aST4);
        aST2.setFirstChild(aST3);
        if (collationSpecification != null) {
            aST2.addChild(collationSpecification);
        }
        if (orderingSpecification != null) {
            aST2.addChild(orderingSpecification);
        }
        return (SortSpecification)aST2;
    }
}

