/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.collections.AST;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRendererTokenTypes;
import org.hibernate.sql.ordering.antlr.Node;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByFragmentRenderer
extends GeneratedOrderByFragmentRenderer {
    private static final Logger log = LoggerFactory.getLogger(OrderByFragmentRenderer.class);
    private static final ASTPrinter printer = new ASTPrinter(GeneratedOrderByFragmentRendererTokenTypes.class);
    private int traceDepth = 0;

    protected void out(AST aST) {
        this.out(((Node)((Object)aST)).getRenderableText());
    }

    public void traceIn(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String string3 = string + " (" + this.buildTraceNodeName(aST) + ")";
        log.trace(string2 + string3);
    }

    private String buildTraceNodeName(AST aST) {
        return aST == null ? "???" : aST.getText() + " [" + printer.getTokenTypeName(aST.getType()) + "]";
    }

    public void traceOut(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        log.trace(string2 + string);
    }
}

