/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.TokenStream;
import java.io.StringReader;
import org.hibernate.HibernateException;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByLexer;
import org.hibernate.sql.ordering.antlr.OrderByFragmentParser;
import org.hibernate.sql.ordering.antlr.OrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.OrderByTemplateTokenTypes;
import org.hibernate.sql.ordering.antlr.TranslationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByFragmentTranslator {
    private static final Logger log = LoggerFactory.getLogger(OrderByFragmentTranslator.class);
    public final TranslationContext context;

    public OrderByFragmentTranslator(TranslationContext translationContext) {
        this.context = translationContext;
    }

    public String render(String string) {
        Object object;
        GeneratedOrderByLexer generatedOrderByLexer = new GeneratedOrderByLexer(new StringReader(string));
        OrderByFragmentParser orderByFragmentParser = new OrderByFragmentParser((TokenStream)generatedOrderByLexer, this.context);
        try {
            orderByFragmentParser.orderByFragment();
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to parse order-by fragment", throwable);
        }
        if (log.isTraceEnabled()) {
            object = new ASTPrinter(OrderByTemplateTokenTypes.class);
            log.trace(((ASTPrinter)object).showAsString(orderByFragmentParser.getAST(), "--- {order-by fragment} ---"));
        }
        object = new OrderByFragmentRenderer();
        try {
            ((GeneratedOrderByFragmentRenderer)object).orderByFragment(orderByFragmentParser.getAST());
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to render parsed order-by fragment", throwable);
        }
        return ((GeneratedOrderByFragmentRenderer)object).getRenderedFragment();
    }
}

