/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.QueryStatistics;

public class ConcurrentQueryStatisticsImpl
extends CategorizedStatistics
implements QueryStatistics {
    private final AtomicLong cacheHitCount = new AtomicLong();
    private final AtomicLong cacheMissCount = new AtomicLong();
    private final AtomicLong cachePutCount = new AtomicLong();
    private final AtomicLong executionCount = new AtomicLong();
    private final AtomicLong executionRowCount = new AtomicLong();
    private final AtomicLong executionMaxTime = new AtomicLong();
    private final AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong totalExecutionTime = new AtomicLong();
    private final Lock readLock;
    private final Lock writeLock;

    ConcurrentQueryStatisticsImpl(String string) {
        super(string);
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
    }

    public long getExecutionCount() {
        return this.executionCount.get();
    }

    public long getCacheHitCount() {
        return this.cacheHitCount.get();
    }

    public long getCachePutCount() {
        return this.cachePutCount.get();
    }

    public long getCacheMissCount() {
        return this.cacheMissCount.get();
    }

    public long getExecutionRowCount() {
        return this.executionRowCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long l = 0L;
            if (this.executionCount.get() > 0L) {
                l = this.totalExecutionTime.get() / this.executionCount.get();
            }
            long l2 = l;
            return l2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    public long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executed(long l, long l2) {
        this.readLock.lock();
        try {
            long l3 = this.executionMinTime.get();
            while (l2 < l3 && !this.executionMinTime.compareAndSet(l3, l2)) {
                l3 = this.executionMinTime.get();
            }
            l3 = this.executionMaxTime.get();
            while (l2 > l3 && !this.executionMaxTime.compareAndSet(l3, l2)) {
                l3 = this.executionMaxTime.get();
            }
            this.executionCount.getAndIncrement();
            this.executionRowCount.addAndGet(l);
            this.totalExecutionTime.addAndGet(l2);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return "QueryStatistics" + "[cacheHitCount=" + this.cacheHitCount + ",cacheMissCount=" + this.cacheMissCount + ",cachePutCount=" + this.cachePutCount + ",executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.getExecutionAvgTime() + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + ']';
    }

    void incrementCacheHitCount() {
        this.cacheHitCount.getAndIncrement();
    }

    void incrementCacheMissCount() {
        this.cacheMissCount.getAndIncrement();
    }

    void incrementCachePutCount() {
        this.cachePutCount.getAndIncrement();
    }
}

