/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.Region;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;

public class ConcurrentSecondLevelCacheStatisticsImpl
extends CategorizedStatistics
implements SecondLevelCacheStatistics {
    private final transient Region region;
    private AtomicLong hitCount = new AtomicLong();
    private AtomicLong missCount = new AtomicLong();
    private AtomicLong putCount = new AtomicLong();

    ConcurrentSecondLevelCacheStatisticsImpl(Region region) {
        super(region.getName());
        this.region = region;
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long getPutCount() {
        return this.putCount.get();
    }

    public long getElementCountInMemory() {
        return this.region.getElementCountInMemory();
    }

    public long getElementCountOnDisk() {
        return this.region.getElementCountOnDisk();
    }

    public long getSizeInMemory() {
        return this.region.getSizeInMemory();
    }

    public Map getEntries() {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.region.toMap().entrySet()) {
            hashMap.put(((CacheKey)entry.getKey()).getKey(), entry.getValue());
        }
        return hashMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("SecondLevelCacheStatistics").append("[hitCount=").append(this.hitCount).append(",missCount=").append(this.missCount).append(",putCount=").append(this.putCount);
        if (this.region != null) {
            stringBuilder.append(",elementCountInMemory=").append(this.getElementCountInMemory()).append(",elementCountOnDisk=").append(this.getElementCountOnDisk()).append(",sizeInMemory=").append(this.getSizeInMemory());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    void incrementHitCount() {
        this.hitCount.getAndIncrement();
    }

    void incrementMissCount() {
        this.missCount.getAndIncrement();
    }

    void incrementPutCount() {
        this.putCount.getAndIncrement();
    }
}

