/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.cache.Region;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.CollectionStatisticsImpl;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.EntityStatisticsImpl;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.QueryStatisticsImpl;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.SecondLevelCacheStatisticsImpl;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.util.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StatisticsImpl
implements Statistics,
StatisticsImplementor {
    private static final Logger log = LoggerFactory.getLogger(StatisticsImpl.class);
    private SessionFactoryImplementor sessionFactory;
    private boolean isStatisticsEnabled;
    private long startTime;
    private long sessionOpenCount;
    private long sessionCloseCount;
    private long flushCount;
    private long connectCount;
    private long prepareStatementCount;
    private long closeStatementCount;
    private long entityLoadCount;
    private long entityUpdateCount;
    private long entityInsertCount;
    private long entityDeleteCount;
    private long entityFetchCount;
    private long collectionLoadCount;
    private long collectionUpdateCount;
    private long collectionRemoveCount;
    private long collectionRecreateCount;
    private long collectionFetchCount;
    private long secondLevelCacheHitCount;
    private long secondLevelCacheMissCount;
    private long secondLevelCachePutCount;
    private long queryExecutionCount;
    private long queryExecutionMaxTime;
    private String queryExecutionMaxTimeQueryString;
    private long queryCacheHitCount;
    private long queryCacheMissCount;
    private long queryCachePutCount;
    private long commitedTransactionCount;
    private long transactionCount;
    private long optimisticFailureCount;
    private final Map secondLevelCacheStatistics = new HashMap();
    private final Map entityStatistics = new HashMap();
    private final Map collectionStatistics = new HashMap();
    private final Map queryStatistics = new HashMap();

    public StatisticsImpl() {
        this.clear();
    }

    public StatisticsImpl(SessionFactoryImplementor sessionFactoryImplementor) {
        this.clear();
        this.sessionFactory = sessionFactoryImplementor;
    }

    public synchronized void clear() {
        this.secondLevelCacheHitCount = 0L;
        this.secondLevelCacheMissCount = 0L;
        this.secondLevelCachePutCount = 0L;
        this.sessionCloseCount = 0L;
        this.sessionOpenCount = 0L;
        this.flushCount = 0L;
        this.connectCount = 0L;
        this.prepareStatementCount = 0L;
        this.closeStatementCount = 0L;
        this.entityDeleteCount = 0L;
        this.entityInsertCount = 0L;
        this.entityUpdateCount = 0L;
        this.entityLoadCount = 0L;
        this.entityFetchCount = 0L;
        this.collectionRemoveCount = 0L;
        this.collectionUpdateCount = 0L;
        this.collectionRecreateCount = 0L;
        this.collectionLoadCount = 0L;
        this.collectionFetchCount = 0L;
        this.queryExecutionCount = 0L;
        this.queryCacheHitCount = 0L;
        this.queryExecutionMaxTime = 0L;
        this.queryExecutionMaxTimeQueryString = null;
        this.queryCacheMissCount = 0L;
        this.queryCachePutCount = 0L;
        this.transactionCount = 0L;
        this.commitedTransactionCount = 0L;
        this.optimisticFailureCount = 0L;
        this.secondLevelCacheStatistics.clear();
        this.entityStatistics.clear();
        this.collectionStatistics.clear();
        this.queryStatistics.clear();
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void openSession() {
        ++this.sessionOpenCount;
    }

    public synchronized void closeSession() {
        ++this.sessionCloseCount;
    }

    public synchronized void flush() {
        ++this.flushCount;
    }

    public synchronized void connect() {
        ++this.connectCount;
    }

    public synchronized void loadEntity(String string) {
        ++this.entityLoadCount;
        ++((EntityStatisticsImpl)this.getEntityStatistics((String)string)).loadCount;
    }

    public synchronized void fetchEntity(String string) {
        ++this.entityFetchCount;
        ++((EntityStatisticsImpl)this.getEntityStatistics((String)string)).fetchCount;
    }

    public synchronized EntityStatistics getEntityStatistics(String string) {
        EntityStatisticsImpl entityStatisticsImpl = (EntityStatisticsImpl)this.entityStatistics.get(string);
        if (entityStatisticsImpl == null) {
            entityStatisticsImpl = new EntityStatisticsImpl(string);
            this.entityStatistics.put(string, entityStatisticsImpl);
        }
        return entityStatisticsImpl;
    }

    public synchronized void updateEntity(String string) {
        ++this.entityUpdateCount;
        EntityStatisticsImpl entityStatisticsImpl = (EntityStatisticsImpl)this.getEntityStatistics(string);
        ++entityStatisticsImpl.updateCount;
    }

    public synchronized void insertEntity(String string) {
        ++this.entityInsertCount;
        EntityStatisticsImpl entityStatisticsImpl = (EntityStatisticsImpl)this.getEntityStatistics(string);
        ++entityStatisticsImpl.insertCount;
    }

    public synchronized void deleteEntity(String string) {
        ++this.entityDeleteCount;
        EntityStatisticsImpl entityStatisticsImpl = (EntityStatisticsImpl)this.getEntityStatistics(string);
        ++entityStatisticsImpl.deleteCount;
    }

    public synchronized CollectionStatistics getCollectionStatistics(String string) {
        CollectionStatisticsImpl collectionStatisticsImpl = (CollectionStatisticsImpl)this.collectionStatistics.get(string);
        if (collectionStatisticsImpl == null) {
            collectionStatisticsImpl = new CollectionStatisticsImpl(string);
            this.collectionStatistics.put(string, collectionStatisticsImpl);
        }
        return collectionStatisticsImpl;
    }

    public synchronized void loadCollection(String string) {
        ++this.collectionLoadCount;
        ++((CollectionStatisticsImpl)this.getCollectionStatistics((String)string)).loadCount;
    }

    public synchronized void fetchCollection(String string) {
        ++this.collectionFetchCount;
        ++((CollectionStatisticsImpl)this.getCollectionStatistics((String)string)).fetchCount;
    }

    public synchronized void updateCollection(String string) {
        ++this.collectionUpdateCount;
        ++((CollectionStatisticsImpl)this.getCollectionStatistics((String)string)).updateCount;
    }

    public synchronized void recreateCollection(String string) {
        ++this.collectionRecreateCount;
        ++((CollectionStatisticsImpl)this.getCollectionStatistics((String)string)).recreateCount;
    }

    public synchronized void removeCollection(String string) {
        ++this.collectionRemoveCount;
        ++((CollectionStatisticsImpl)this.getCollectionStatistics((String)string)).removeCount;
    }

    public synchronized SecondLevelCacheStatistics getSecondLevelCacheStatistics(String string) {
        SecondLevelCacheStatisticsImpl secondLevelCacheStatisticsImpl = (SecondLevelCacheStatisticsImpl)this.secondLevelCacheStatistics.get(string);
        if (secondLevelCacheStatisticsImpl == null) {
            if (this.sessionFactory == null) {
                return null;
            }
            Region region = this.sessionFactory.getSecondLevelCacheRegion(string);
            if (region == null) {
                return null;
            }
            secondLevelCacheStatisticsImpl = new SecondLevelCacheStatisticsImpl(region);
            this.secondLevelCacheStatistics.put(string, secondLevelCacheStatisticsImpl);
        }
        return secondLevelCacheStatisticsImpl;
    }

    public synchronized void secondLevelCachePut(String string) {
        ++this.secondLevelCachePutCount;
        ++((SecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics((String)string)).putCount;
    }

    public synchronized void secondLevelCacheHit(String string) {
        ++this.secondLevelCacheHitCount;
        ++((SecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics((String)string)).hitCount;
    }

    public synchronized void secondLevelCacheMiss(String string) {
        ++this.secondLevelCacheMissCount;
        ++((SecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics((String)string)).missCount;
    }

    public synchronized void queryExecuted(String string, int n, long l) {
        ++this.queryExecutionCount;
        if (this.queryExecutionMaxTime < l) {
            this.queryExecutionMaxTime = l;
            this.queryExecutionMaxTimeQueryString = string;
        }
        if (string != null) {
            QueryStatisticsImpl queryStatisticsImpl = (QueryStatisticsImpl)this.getQueryStatistics(string);
            queryStatisticsImpl.executed(n, l);
            log.info("HQL: {}, time: {}ms, rows: {}", new Object[]{string, new Long(l), new Long(n)});
        }
    }

    public synchronized void queryCacheHit(String string, String string2) {
        CategorizedStatistics categorizedStatistics;
        ++this.queryCacheHitCount;
        if (string != null) {
            categorizedStatistics = (QueryStatisticsImpl)this.getQueryStatistics(string);
            ++categorizedStatistics.cacheHitCount;
        }
        categorizedStatistics = (SecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(string2);
        ++((SecondLevelCacheStatisticsImpl)categorizedStatistics).hitCount;
    }

    public synchronized void queryCacheMiss(String string, String string2) {
        CategorizedStatistics categorizedStatistics;
        ++this.queryCacheMissCount;
        if (string != null) {
            categorizedStatistics = (QueryStatisticsImpl)this.getQueryStatistics(string);
            ++categorizedStatistics.cacheMissCount;
        }
        categorizedStatistics = (SecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(string2);
        ++((SecondLevelCacheStatisticsImpl)categorizedStatistics).missCount;
    }

    public synchronized void queryCachePut(String string, String string2) {
        CategorizedStatistics categorizedStatistics;
        ++this.queryCachePutCount;
        if (string != null) {
            categorizedStatistics = (QueryStatisticsImpl)this.getQueryStatistics(string);
            ++categorizedStatistics.cachePutCount;
        }
        categorizedStatistics = (SecondLevelCacheStatisticsImpl)this.getSecondLevelCacheStatistics(string2);
        ++((SecondLevelCacheStatisticsImpl)categorizedStatistics).putCount;
    }

    public synchronized QueryStatistics getQueryStatistics(String string) {
        QueryStatisticsImpl queryStatisticsImpl = (QueryStatisticsImpl)this.queryStatistics.get(string);
        if (queryStatisticsImpl == null) {
            queryStatisticsImpl = new QueryStatisticsImpl(string);
            this.queryStatistics.put(string, queryStatisticsImpl);
        }
        return queryStatisticsImpl;
    }

    public long getEntityDeleteCount() {
        return this.entityDeleteCount;
    }

    public long getEntityInsertCount() {
        return this.entityInsertCount;
    }

    public long getEntityLoadCount() {
        return this.entityLoadCount;
    }

    public long getEntityFetchCount() {
        return this.entityFetchCount;
    }

    public long getEntityUpdateCount() {
        return this.entityUpdateCount;
    }

    public long getQueryExecutionCount() {
        return this.queryExecutionCount;
    }

    public long getQueryCacheHitCount() {
        return this.queryCacheHitCount;
    }

    public long getQueryCacheMissCount() {
        return this.queryCacheMissCount;
    }

    public long getQueryCachePutCount() {
        return this.queryCachePutCount;
    }

    public long getFlushCount() {
        return this.flushCount;
    }

    public long getConnectCount() {
        return this.connectCount;
    }

    public long getSecondLevelCacheHitCount() {
        return this.secondLevelCacheHitCount;
    }

    public long getSecondLevelCacheMissCount() {
        return this.secondLevelCacheMissCount;
    }

    public long getSecondLevelCachePutCount() {
        return this.secondLevelCachePutCount;
    }

    public long getSessionCloseCount() {
        return this.sessionCloseCount;
    }

    public long getSessionOpenCount() {
        return this.sessionOpenCount;
    }

    public long getCollectionLoadCount() {
        return this.collectionLoadCount;
    }

    public long getCollectionFetchCount() {
        return this.collectionFetchCount;
    }

    public long getCollectionUpdateCount() {
        return this.collectionUpdateCount;
    }

    public long getCollectionRemoveCount() {
        return this.collectionRemoveCount;
    }

    public long getCollectionRecreateCount() {
        return this.collectionRecreateCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void logSummary() {
        log.info("Logging statistics....");
        log.info("start time: " + this.startTime);
        log.info("sessions opened: " + this.sessionOpenCount);
        log.info("sessions closed: " + this.sessionCloseCount);
        log.info("transactions: " + this.transactionCount);
        log.info("successful transactions: " + this.commitedTransactionCount);
        log.info("optimistic lock failures: " + this.optimisticFailureCount);
        log.info("flushes: " + this.flushCount);
        log.info("connections obtained: " + this.connectCount);
        log.info("statements prepared: " + this.prepareStatementCount);
        log.info("statements closed: " + this.closeStatementCount);
        log.info("second level cache puts: " + this.secondLevelCachePutCount);
        log.info("second level cache hits: " + this.secondLevelCacheHitCount);
        log.info("second level cache misses: " + this.secondLevelCacheMissCount);
        log.info("entities loaded: " + this.entityLoadCount);
        log.info("entities updated: " + this.entityUpdateCount);
        log.info("entities inserted: " + this.entityInsertCount);
        log.info("entities deleted: " + this.entityDeleteCount);
        log.info("entities fetched (minimize this): " + this.entityFetchCount);
        log.info("collections loaded: " + this.collectionLoadCount);
        log.info("collections updated: " + this.collectionUpdateCount);
        log.info("collections removed: " + this.collectionRemoveCount);
        log.info("collections recreated: " + this.collectionRecreateCount);
        log.info("collections fetched (minimize this): " + this.collectionFetchCount);
        log.info("queries executed to database: " + this.queryExecutionCount);
        log.info("query cache puts: " + this.queryCachePutCount);
        log.info("query cache hits: " + this.queryCacheHitCount);
        log.info("query cache misses: " + this.queryCacheMissCount);
        log.info("max query time: " + this.queryExecutionMaxTime + "ms");
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean bl) {
        this.isStatisticsEnabled = bl;
    }

    public long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime;
    }

    public String[] getQueries() {
        return ArrayHelper.toStringArray(this.queryStatistics.keySet());
    }

    public String[] getEntityNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.entityStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllClassMetadata().keySet());
    }

    public String[] getCollectionRoleNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.collectionStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllCollectionMetadata().keySet());
    }

    public String[] getSecondLevelCacheRegionNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.secondLevelCacheStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllSecondLevelCacheRegions().keySet());
    }

    public void endTransaction(boolean bl) {
        ++this.transactionCount;
        if (bl) {
            ++this.commitedTransactionCount;
        }
    }

    public long getSuccessfulTransactionCount() {
        return this.commitedTransactionCount;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public void closeStatement() {
        ++this.closeStatementCount;
    }

    public void prepareStatement() {
        ++this.prepareStatementCount;
    }

    public long getCloseStatementCount() {
        return this.closeStatementCount;
    }

    public long getPrepareStatementCount() {
        return this.prepareStatementCount;
    }

    public void optimisticFailure(String string) {
        ++this.optimisticFailureCount;
        ++((EntityStatisticsImpl)this.getEntityStatistics((String)string)).optimisticFailureCount;
    }

    public long getOptimisticFailureCount() {
        return this.optimisticFailureCount;
    }

    public String toString() {
        return new StringBuffer().append("Statistics[").append("start time=").append(this.startTime).append(",sessions opened=").append(this.sessionOpenCount).append(",sessions closed=").append(this.sessionCloseCount).append(",transactions=").append(this.transactionCount).append(",successful transactions=").append(this.commitedTransactionCount).append(",optimistic lock failures=").append(this.optimisticFailureCount).append(",flushes=").append(this.flushCount).append(",connections obtained=").append(this.connectCount).append(",statements prepared=").append(this.prepareStatementCount).append(",statements closed=").append(this.closeStatementCount).append(",second level cache puts=").append(this.secondLevelCachePutCount).append(",second level cache hits=").append(this.secondLevelCacheHitCount).append(",second level cache misses=").append(this.secondLevelCacheMissCount).append(",entities loaded=").append(this.entityLoadCount).append(",entities updated=").append(this.entityUpdateCount).append(",entities inserted=").append(this.entityInsertCount).append(",entities deleted=").append(this.entityDeleteCount).append(",entities fetched=").append(this.entityFetchCount).append(",collections loaded=").append(this.collectionLoadCount).append(",collections updated=").append(this.collectionUpdateCount).append(",collections removed=").append(this.collectionRemoveCount).append(",collections recreated=").append(this.collectionRecreateCount).append(",collections fetched=").append(this.collectionFetchCount).append(",queries executed to database=").append(this.queryExecutionCount).append(",query cache puts=").append(this.queryCachePutCount).append(",query cache hits=").append(this.queryCacheHitCount).append(",query cache misses=").append(this.queryCacheMissCount).append(",max query time=").append(this.queryExecutionMaxTime).append(']').toString();
    }

    public String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }
}

