/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.jdbc.util.Formatter;
import org.hibernate.jdbc.util.SQLStatementLogger;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExport {
    private static final Logger log = LoggerFactory.getLogger(SchemaExport.class);
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private String importFiles;
    private Dialect dialect;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private boolean haltOnError = false;
    private Formatter formatter;
    private SQLStatementLogger sqlStatementLogger;
    private static final String DEFAULT_IMPORT_FILE = "/import.sql";

    public SchemaExport(Configuration configuration) throws HibernateException {
        this(configuration, configuration.getProperties());
    }

    public SchemaExport(Configuration configuration, Settings settings) throws HibernateException {
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.dropSQL = configuration.generateDropSchemaScript(this.dialect);
        this.createSQL = configuration.generateSchemaCreationScript(this.dialect);
        this.sqlStatementLogger = settings.getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormatSql() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.importFiles = settings.getImportFiles() != null ? settings.getImportFiles() : DEFAULT_IMPORT_FILE;
    }

    public SchemaExport(Configuration configuration, Properties properties) throws HibernateException {
        this.dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
        this.dropSQL = configuration.generateDropSchemaScript(this.dialect);
        this.createSQL = configuration.generateSchemaCreationScript(this.dialect);
        this.formatter = (PropertiesHelper.getBoolean("hibernate.format_sql", properties2) ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.importFiles = PropertiesHelper.getString("hibernate.hbm2ddl.import_files", properties2, DEFAULT_IMPORT_FILE);
    }

    public SchemaExport(Configuration configuration, Connection connection) throws HibernateException {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(configuration.getProperties());
        this.dropSQL = configuration.generateDropSchemaScript(this.dialect);
        this.createSQL = configuration.generateSchemaCreationScript(this.dialect);
        this.formatter = (PropertiesHelper.getBoolean("hibernate.format_sql", configuration.getProperties()) ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.importFiles = PropertiesHelper.getString("hibernate.hbm2ddl.import_files", configuration.getProperties(), DEFAULT_IMPORT_FILE);
    }

    public SchemaExport setOutputFile(String string) {
        this.outputFile = string;
        return this;
    }

    public SchemaExport setImportFile(String string) {
        this.importFiles = string;
        return this;
    }

    public SchemaExport setDelimiter(String string) {
        this.delimiter = string;
        return this;
    }

    public SchemaExport setFormat(boolean bl) {
        this.formatter = (bl ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        return this;
    }

    public SchemaExport setHaltOnError(boolean bl) {
        this.haltOnError = bl;
        return this;
    }

    public void create(boolean bl, boolean bl2) {
        this.execute(bl, bl2, false, false);
    }

    public void drop(boolean bl, boolean bl2) {
        this.execute(bl, bl2, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block39: {
            log.info("Running hbm2ddl schema export");
            Connection connection = null;
            Writer writer = null;
            ArrayList<NamedReader> arrayList = new ArrayList<NamedReader>();
            Statement statement = null;
            this.exceptions.clear();
            for (String string : this.importFiles.split(",")) {
                try {
                    String string2 = string.trim();
                    InputStream inputStream = ConfigHelper.getResourceAsStream(string2);
                    arrayList.add(new NamedReader(string2, inputStream));
                }
                catch (HibernateException hibernateException) {
                    log.debug("import file not found: " + string);
                }
            }
            if (this.outputFile != null) {
                log.info("writing generated schema to file: " + this.outputFile);
                writer = new FileWriter(this.outputFile);
            }
            if (bl2) {
                log.info("exporting generated schema to database");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                statement = connection.createStatement();
            }
            if (!bl4) {
                this.drop(bl, bl2, writer, statement);
            }
            if (!bl3) {
                this.create(bl, bl2, writer, statement);
                if (bl2 && arrayList.size() > 0) {
                    for (NamedReader namedReader : arrayList) {
                        this.importScript(namedReader, statement);
                    }
                }
            }
            log.info("schema export complete");
            Object var16_18 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.connectionHelper.release();
                }
            }
            catch (Exception object) {
                this.exceptions.add(object);
                log.error("Could not close connection", (Throwable)object);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException object) {
                this.exceptions.add(object);
                log.error("Error closing output file: " + this.outputFile, (Throwable)object);
            }
            for (NamedReader namedReader : arrayList) {
                try {
                    namedReader.getReader().close();
                }
                catch (IOException iOException) {
                    this.exceptions.add(iOException);
                    log.error("Error closing imput files: " + namedReader.getName(), iOException);
                }
            }
            {
                break block39;
                catch (Exception exception) {
                    this.exceptions.add(exception);
                    log.error("schema export unsuccessful", exception);
                    Object var16_19 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            this.connectionHelper.release();
                        }
                    }
                    catch (Exception object) {
                        this.exceptions.add(object);
                        log.error("Could not close connection", (Throwable)object);
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException object) {
                        this.exceptions.add(object);
                        log.error("Error closing output file: " + this.outputFile, (Throwable)object);
                    }
                    for (NamedReader namedReader : arrayList) {
                        try {
                            namedReader.getReader().close();
                        }
                        catch (IOException iOException) {
                            this.exceptions.add(iOException);
                            log.error("Error closing imput files: " + namedReader.getName(), iOException);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionHelper.release();
                    }
                }
                catch (Exception object) {
                    this.exceptions.add(object);
                    log.error("Could not close connection", (Throwable)object);
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException object) {
                    this.exceptions.add(object);
                    log.error("Error closing output file: " + this.outputFile, (Throwable)object);
                }
                for (NamedReader namedReader : arrayList) {
                    try {
                        namedReader.getReader().close();
                    }
                    catch (IOException iOException) {
                        this.exceptions.add(iOException);
                        log.error("Error closing imput files: " + namedReader.getName(), iOException);
                    }
                }
                throw throwable;
            }
        }
    }

    private void importScript(NamedReader namedReader, Statement statement) throws IOException {
        log.info("Executing import script: " + namedReader.getName());
        BufferedReader bufferedReader = new BufferedReader(namedReader.getReader());
        long l = 0L;
        String string = bufferedReader.readLine();
        while (string != null) {
            try {
                ++l;
                String string2 = string.trim();
                if (!(string2.length() == 0 || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*"))) {
                    if (string2.endsWith(";")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    log.debug(string2);
                    statement.execute(string2);
                }
            }
            catch (SQLException sQLException) {
                throw new JDBCException("Error during import script execution at line " + l, sQLException);
            }
            string = bufferedReader.readLine();
        }
    }

    private void create(boolean bl, boolean bl2, Writer writer, Statement statement) throws IOException {
        for (int i = 0; i < this.createSQL.length; ++i) {
            try {
                this.execute(bl, bl2, writer, statement, this.createSQL[i]);
                continue;
            }
            catch (SQLException sQLException) {
                if (this.haltOnError) {
                    throw new JDBCException("Error during DDL export", sQLException);
                }
                this.exceptions.add(sQLException);
                log.error("Unsuccessful: " + this.createSQL[i]);
                log.error(sQLException.getMessage());
            }
        }
    }

    private void drop(boolean bl, boolean bl2, Writer writer, Statement statement) throws IOException {
        for (int i = 0; i < this.dropSQL.length; ++i) {
            try {
                this.execute(bl, bl2, writer, statement, this.dropSQL[i]);
                continue;
            }
            catch (SQLException sQLException) {
                this.exceptions.add(sQLException);
                log.debug("Unsuccessful: " + this.dropSQL[i]);
                log.debug(sQLException.getMessage());
            }
        }
    }

    private void execute(boolean bl, boolean bl2, Writer writer, Statement statement, String string) throws IOException, SQLException {
        String string2 = this.formatter.format(string);
        if (this.delimiter != null) {
            string2 = string2 + this.delimiter;
        }
        if (bl) {
            System.out.println(string2);
        }
        log.debug(string2);
        if (this.outputFile != null) {
            writer.write(string2 + "\n");
        }
        if (bl2) {
            statement.executeUpdate(string);
            try {
                SQLWarning sQLWarning = statement.getWarnings();
                if (sQLWarning != null) {
                    JDBCExceptionReporter.logAndClearWarnings(this.connectionHelper.getConnection());
                }
            }
            catch (SQLException sQLException) {
                log.warn("unable to log SQLWarnings : " + sQLException);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Configuration configuration = new Configuration();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            String string = null;
            String string2 = DEFAULT_IMPORT_FILE;
            String string3 = null;
            boolean bl6 = false;
            String string4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].equals("--quiet")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].equals("--drop")) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--create")) {
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--haltonerror")) {
                        bl4 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--text")) {
                        bl5 = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("--output=")) {
                        string = stringArray[i].substring(9);
                        continue;
                    }
                    if (stringArray[i].startsWith("--import=")) {
                        string2 = stringArray[i].substring(9);
                        continue;
                    }
                    if (stringArray[i].startsWith("--properties=")) {
                        string3 = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].equals("--format")) {
                        bl6 = true;
                        continue;
                    }
                    if (stringArray[i].startsWith("--delimiter=")) {
                        string4 = stringArray[i].substring(12);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                String string5 = stringArray[i];
                if (string5.endsWith(".jar")) {
                    configuration.addJar(new File(string5));
                    continue;
                }
                configuration.addFile(string5);
            }
            if (string3 != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string3));
                configuration.setProperties(properties);
            }
            if (string2 != null) {
                configuration.setProperty("hibernate.hbm2ddl.import_files", string2);
            }
            SchemaExport schemaExport = new SchemaExport(configuration).setHaltOnError(bl4).setOutputFile(string).setDelimiter(string4);
            if (bl6) {
                schemaExport.setFormat(true);
            }
            schemaExport.execute(bl, bl5, bl2, bl3);
        }
        catch (Exception exception) {
            log.error("Error creating schema ", exception);
            exception.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    private class NamedReader {
        private final Reader reader;
        private final String name;

        public NamedReader(String string, InputStream inputStream) {
            this.name = string;
            this.reader = new InputStreamReader(inputStream);
        }

        public Reader getReader() {
            return this.reader;
        }

        public String getName() {
            return this.name;
        }
    }
}

