/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.jdbc.util.Formatter;
import org.hibernate.jdbc.util.SQLStatementLogger;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate {
    private static final Logger log = LoggerFactory.getLogger(SchemaUpdate.class);
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;
    private boolean haltOnError = false;
    private boolean format = true;
    private String outputFile = null;
    private String delimiter;
    private Formatter formatter;
    private SQLStatementLogger sqlStatementLogger;

    public SchemaUpdate(Configuration configuration) throws HibernateException {
        this(configuration, configuration.getProperties());
    }

    public SchemaUpdate(Configuration configuration, Properties properties) throws HibernateException {
        this.configuration = configuration;
        this.dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
        this.exceptions = new ArrayList();
        this.formatter = (PropertiesHelper.getBoolean("hibernate.format_sql", properties2) ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public SchemaUpdate(Configuration configuration, Settings settings) throws HibernateException {
        this.configuration = configuration;
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.exceptions = new ArrayList();
        this.sqlStatementLogger = settings.getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormatSql() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public static void main(String[] stringArray) {
        try {
            Configuration configuration = new Configuration();
            boolean bl = true;
            boolean bl2 = true;
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].equals("--quiet")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("--properties=")) {
                        string = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (stringArray[i].startsWith("--text")) {
                        bl2 = false;
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                configuration.addFile(stringArray[i]);
            }
            if (string != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string));
                configuration.setProperties(properties);
            }
            new SchemaUpdate(configuration).execute(bl, bl2);
        }
        catch (Exception exception) {
            log.error("Error running schema update", exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean bl, boolean bl2) {
        log.info("Running hbm2ddl schema update");
        Connection connection = null;
        Statement statement = null;
        Writer writer = null;
        this.exceptions.clear();
        try {
            DatabaseMetadata databaseMetadata;
            try {
                log.info("fetching database metadata");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                databaseMetadata = new DatabaseMetadata(connection, this.dialect);
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                this.exceptions.add(sQLException);
                log.error("could not get database metadata", sQLException);
                throw sQLException;
            }
            log.info("updating schema");
            if (this.outputFile != null) {
                log.info("writing generated schema to file: " + this.outputFile);
                writer = new FileWriter(this.outputFile);
            }
            String[] stringArray = this.configuration.generateSchemaUpdateScript(this.dialect, databaseMetadata);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = this.formatter.format(string);
                try {
                    if (this.delimiter != null) {
                        string2 = string2 + this.delimiter;
                    }
                    if (bl) {
                        System.out.println(string2);
                    }
                    if (this.outputFile != null) {
                        writer.write(string2 + "\n");
                    }
                    if (!bl2) continue;
                    log.debug(string);
                    statement.executeUpdate(string2);
                    continue;
                }
                catch (SQLException sQLException) {
                    if (this.haltOnError) {
                        throw new JDBCException("Error during DDL export", sQLException);
                    }
                    this.exceptions.add(sQLException);
                    log.error("Unsuccessful: " + string);
                    log.error(sQLException.getMessage());
                }
            }
            log.info("schema update complete");
        }
        catch (Exception exception) {
            this.exceptions.add(exception);
            log.error("could not complete schema update", exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
                log.error("Error closing connection", exception);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
                log.error("Error closing connection", exception);
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setHaltOnError(boolean bl) {
        this.haltOnError = bl;
    }

    public void setFormat(boolean bl) {
        this.formatter = (bl ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }
}

