/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadata {
    private static final Logger log = LoggerFactory.getLogger(TableMetadata.class);
    private final String catalog;
    private final String schema;
    private final String name;
    private final Map columns = new HashMap();
    private final Map foreignKeys = new HashMap();
    private final Map indexes = new HashMap();

    TableMetadata(ResultSet resultSet, DatabaseMetaData databaseMetaData, boolean bl) throws SQLException {
        this.catalog = resultSet.getString("TABLE_CAT");
        this.schema = resultSet.getString("TABLE_SCHEM");
        this.name = resultSet.getString("TABLE_NAME");
        this.initColumns(databaseMetaData);
        if (bl) {
            this.initForeignKeys(databaseMetaData);
            this.initIndexes(databaseMetaData);
        }
        String string = this.catalog == null ? "" : this.catalog + '.';
        String string2 = this.schema == null ? "" : this.schema + '.';
        log.info("table found: " + string + string2 + this.name);
        log.info("columns: " + this.columns.keySet());
        if (bl) {
            log.info("foreign keys: " + this.foreignKeys.keySet());
            log.info("indexes: " + this.indexes.keySet());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String toString() {
        return "TableMetadata(" + this.name + ')';
    }

    public ColumnMetadata getColumnMetadata(String string) {
        return (ColumnMetadata)this.columns.get(string.toLowerCase());
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String string) {
        return (ForeignKeyMetadata)this.foreignKeys.get(string.toLowerCase());
    }

    public ForeignKeyMetadata getForeignKeyMetadata(ForeignKey foreignKey) {
        for (ForeignKeyMetadata foreignKeyMetadata : this.foreignKeys.values()) {
            if (!foreignKeyMetadata.matches(foreignKey)) continue;
            return foreignKeyMetadata;
        }
        return null;
    }

    public IndexMetadata getIndexMetadata(String string) {
        return (IndexMetadata)this.indexes.get(string.toLowerCase());
    }

    private void addForeignKey(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("FK_NAME");
        if (string == null) {
            return;
        }
        ForeignKeyMetadata foreignKeyMetadata = this.getForeignKeyMetadata(string);
        if (foreignKeyMetadata == null) {
            foreignKeyMetadata = new ForeignKeyMetadata(resultSet);
            this.foreignKeys.put(foreignKeyMetadata.getName().toLowerCase(), foreignKeyMetadata);
        }
        foreignKeyMetadata.addReference(resultSet);
    }

    private void addIndex(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("INDEX_NAME");
        if (string == null) {
            return;
        }
        IndexMetadata indexMetadata = this.getIndexMetadata(string);
        if (indexMetadata == null) {
            indexMetadata = new IndexMetadata(resultSet);
            this.indexes.put(indexMetadata.getName().toLowerCase(), indexMetadata);
        }
        indexMetadata.addColumn(this.getColumnMetadata(resultSet.getString("COLUMN_NAME")));
    }

    public void addColumn(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("COLUMN_NAME");
        if (string == null) {
            return;
        }
        if (this.getColumnMetadata(string) == null) {
            ColumnMetadata columnMetadata = new ColumnMetadata(resultSet);
            this.columns.put(columnMetadata.getName().toLowerCase(), columnMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForeignKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getImportedKeys(this.catalog, this.schema, this.name);
            while (resultSet.next()) {
                this.addForeignKey(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexes(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getIndexInfo(this.catalog, this.schema, this.name, false, true);
            while (resultSet.next()) {
                if (resultSet.getShort("TYPE") == 0) continue;
                this.addIndex(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getColumns(this.catalog, this.schema, this.name, "%");
            while (resultSet.next()) {
                this.addColumn(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }
}

