/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMTTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(CMTTransaction.class);
    protected final JDBCContext jdbcContext;
    protected final TransactionFactory.Context transactionContext;
    private boolean begun;

    public CMTTransaction(JDBCContext jDBCContext, TransactionFactory.Context context) {
        this.jdbcContext = jDBCContext;
        this.transactionContext = context;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        log.debug("begin");
        boolean bl = this.jdbcContext.registerSynchronizationIfPossible();
        if (!bl) {
            throw new TransactionException("Could not register synchronization for container transaction");
        }
        this.begun = true;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean bl;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("commit");
        boolean bl2 = bl = !this.transactionContext.isFlushModeNever() && !this.transactionContext.isFlushBeforeCompletionEnabled();
        if (bl) {
            this.transactionContext.managedFlush();
        }
        this.begun = false;
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("rollback");
        try {
            this.getTransaction().setRollbackOnly();
        }
        catch (SystemException systemException) {
            log.error("Could not set transaction to rollback only", systemException);
            throw new TransactionException("Could not set transaction to rollback only", systemException);
        }
        this.begun = false;
    }

    public javax.transaction.Transaction getTransaction() throws SystemException {
        return this.transactionContext.getFactory().getTransactionManager().getTransaction();
    }

    public boolean isActive() throws TransactionException {
        int n;
        if (!this.begun) {
            return false;
        }
        try {
            n = this.getTransaction().getStatus();
        }
        catch (SystemException systemException) {
            log.error("Could not determine transaction status", systemException);
            throw new TransactionException("Could not determine transaction status: ", systemException);
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 0;
    }

    public boolean wasRolledBack() throws TransactionException {
        int n;
        if (!this.begun) {
            return false;
        }
        try {
            n = this.getTransaction().getStatus();
        }
        catch (SystemException systemException) {
            log.error("Could not determine transaction status", systemException);
            throw new TransactionException("Could not determine transaction status", systemException);
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(n);
    }

    public boolean wasCommitted() throws TransactionException {
        int n;
        if (!this.begun) {
            return false;
        }
        try {
            n = this.getTransaction().getStatus();
        }
        catch (SystemException systemException) {
            log.error("Could not determine transaction status", systemException);
            throw new TransactionException("Could not determine transaction status: ", systemException);
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 3;
    }

    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        try {
            this.getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception exception) {
            throw new TransactionException("Could not register synchronization", exception);
        }
    }

    public void setTimeout(int n) {
        throw new UnsupportedOperationException("cannot set transaction timeout in CMT");
    }
}

