/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheSynchronization
implements Synchronization {
    private static final Logger log = LoggerFactory.getLogger(CacheSynchronization.class);
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction transaction;
    private final Transaction hibernateTransaction;

    public CacheSynchronization(TransactionFactory.Context context, JDBCContext jDBCContext, javax.transaction.Transaction transaction, Transaction transaction2) {
        this.ctx = context;
        this.jdbcContext = jDBCContext;
        this.transaction = transaction;
        this.hibernateTransaction = transaction2;
    }

    public void beforeCompletion() {
        boolean bl;
        log.trace("transaction before completion callback");
        try {
            bl = !this.ctx.isFlushModeNever() && this.ctx.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(this.transaction.getStatus());
        }
        catch (SystemException systemException) {
            log.error("could not determine transaction status", systemException);
            this.setRollbackOnly();
            throw new TransactionException("could not determine transaction status in beforeCompletion()", systemException);
        }
        try {
            if (bl) {
                log.trace("automatically flushing session");
                this.ctx.managedFlush();
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
        finally {
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
        }
    }

    private void setRollbackOnly() {
        try {
            this.transaction.setRollbackOnly();
        }
        catch (SystemException systemException) {
            log.error("could not set transaction to rollback only", systemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int n) {
        if (log.isTraceEnabled()) {
            log.trace("transaction after completion callback, status: " + n);
        }
        try {
            this.jdbcContext.afterTransactionCompletion(n == 3, this.hibernateTransaction);
        }
        finally {
            if (this.ctx.shouldAutoClose() && !this.ctx.isClosed()) {
                log.trace("automatically closing session");
                this.ctx.managedClose();
            }
        }
    }

    public String toString() {
        return CacheSynchronization.class.getName();
    }
}

