/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.sql.SQLException;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.SynchronizationRegistry;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(JDBCTransaction.class);
    private final SynchronizationRegistry synchronizationRegistry = new SynchronizationRegistry();
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private boolean toggleAutoCommit;
    private boolean begun;
    private boolean rolledBack;
    private boolean committed;
    private boolean commitFailed;
    private boolean callback;
    private int timeout = -1;

    public JDBCTransaction(JDBCContext jDBCContext, TransactionFactory.Context context) {
        this.jdbcContext = jDBCContext;
        this.transactionContext = context;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        if (this.commitFailed) {
            throw new TransactionException("cannot re-start transaction after failed commit");
        }
        log.debug("begin");
        try {
            this.toggleAutoCommit = this.jdbcContext.connection().getAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug("current autocommit status: " + this.toggleAutoCommit);
            }
            if (this.toggleAutoCommit) {
                log.debug("disabling autocommit");
                this.jdbcContext.connection().setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            log.error("JDBC begin failed", sQLException);
            throw new TransactionException("JDBC begin failed: ", sQLException);
        }
        this.callback = this.jdbcContext.registerCallbackIfNecessary();
        this.begun = true;
        this.committed = false;
        this.rolledBack = false;
        if (this.timeout > 0) {
            this.jdbcContext.getConnectionManager().getBatcher().setTransactionTimeout(this.timeout);
        }
        this.jdbcContext.afterTransactionBegin(this);
    }

    private void closeIfRequired() throws HibernateException {
        if (this.callback && this.transactionContext.shouldAutoClose() && !this.transactionContext.isClosed()) {
            try {
                this.transactionContext.managedClose();
            }
            catch (HibernateException hibernateException) {
                log.error("Could not close session", hibernateException);
            }
        }
    }

    public void commit() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("commit");
        if (!this.transactionContext.isFlushModeNever() && this.callback) {
            this.transactionContext.managedFlush();
        }
        this.notifySynchronizationsBeforeTransactionCompletion();
        if (this.callback) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        try {
            this.commitAndResetAutoCommit();
            log.debug("committed JDBC Connection");
            this.committed = true;
            if (this.callback) {
                this.jdbcContext.afterTransactionCompletion(true, this);
            }
            this.notifySynchronizationsAfterTransactionCompletion(3);
        }
        catch (SQLException sQLException) {
            log.error("JDBC commit failed", sQLException);
            this.commitFailed = true;
            if (this.callback) {
                this.jdbcContext.afterTransactionCompletion(false, this);
            }
            this.notifySynchronizationsAfterTransactionCompletion(5);
            throw new TransactionException("JDBC commit failed", sQLException);
        }
        finally {
            this.closeIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitAndResetAutoCommit() throws SQLException {
        try {
            this.jdbcContext.connection().commit();
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun && !this.commitFailed) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("rollback");
        if (!this.commitFailed) {
            try {
                this.rollbackAndResetAutoCommit();
                log.debug("rolled back JDBC Connection");
                this.rolledBack = true;
                this.notifySynchronizationsAfterTransactionCompletion(4);
            }
            catch (SQLException sQLException) {
                log.error("JDBC rollback failed", sQLException);
                this.notifySynchronizationsAfterTransactionCompletion(5);
                throw new TransactionException("JDBC rollback failed", sQLException);
            }
            finally {
                if (this.callback) {
                    this.jdbcContext.afterTransactionCompletion(false, this);
                }
                this.closeIfRequired();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackAndResetAutoCommit() throws SQLException {
        try {
            this.jdbcContext.connection().rollback();
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    private void toggleAutoCommit() {
        try {
            if (this.toggleAutoCommit) {
                log.debug("re-enabling autocommit");
                this.jdbcContext.connection().setAutoCommit(true);
            }
        }
        catch (Exception exception) {
            log.error("Could not toggle autocommit", exception);
        }
    }

    public boolean wasRolledBack() {
        return this.rolledBack;
    }

    public boolean wasCommitted() {
        return this.committed;
    }

    public boolean isActive() {
        return this.begun && !this.rolledBack && !(this.committed | this.commitFailed);
    }

    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizationRegistry.registerSynchronization(synchronization);
    }

    private void notifySynchronizationsBeforeTransactionCompletion() {
        this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
    }

    private void notifySynchronizationsAfterTransactionCompletion(int n) {
        this.begun = false;
        this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(n);
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }
}

