/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.NamingHelper;

public abstract class JNDITransactionManagerLookup
implements TransactionManagerLookup {
    protected abstract String getName();

    public TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        try {
            return (TransactionManager)NamingHelper.getInitialContext(properties).lookup(this.getName());
        }
        catch (NamingException namingException) {
            throw new HibernateException("Could not locate TransactionManager", namingException);
        }
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }
}

