/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTATransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(JTATransaction.class);
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private UserTransaction userTransaction;
    private boolean newTransaction;
    private boolean begun;
    private boolean commitFailed;
    private boolean commitSucceeded;
    private boolean callback;
    private static final int NULL = Integer.MIN_VALUE;

    public JTATransaction(UserTransaction userTransaction, JDBCContext jDBCContext, TransactionFactory.Context context) {
        this.jdbcContext = jDBCContext;
        this.transactionContext = context;
        this.userTransaction = userTransaction;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        if (this.commitFailed) {
            throw new TransactionException("cannot re-start transaction after failed commit");
        }
        log.debug("begin");
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
                log.debug("Began a new JTA transaction");
            }
        }
        catch (Exception exception) {
            log.error("JTA transaction begin failed", exception);
            throw new TransactionException("JTA transaction begin failed", exception);
        }
        boolean bl = this.jdbcContext.registerSynchronizationIfPossible();
        if (!this.newTransaction && !bl) {
            log.warn("You should set hibernate.transaction.manager_lookup_class if cache is enabled");
        }
        if (!bl) {
            this.callback = this.jdbcContext.registerCallbackIfNecessary();
        }
        this.begun = true;
        this.commitSucceeded = false;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean bl;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("commit");
        boolean bl2 = bl = !this.transactionContext.isFlushModeNever() && (this.callback || !this.transactionContext.isFlushBeforeCompletionEnabled());
        if (bl) {
            this.transactionContext.managedFlush();
        }
        if (this.callback && this.newTransaction) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        this.closeIfRequired();
        if (this.newTransaction) {
            try {
                this.userTransaction.commit();
                this.commitSucceeded = true;
                log.debug("Committed JTA UserTransaction");
            }
            catch (Exception exception) {
                this.commitFailed = true;
                log.error("JTA commit failed", exception);
                throw new TransactionException("JTA commit failed: ", exception);
            }
            finally {
                this.afterCommitRollback();
            }
        } else {
            this.afterCommitRollback();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun && !this.commitFailed) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("rollback");
        try {
            this.closeIfRequired();
        }
        catch (Exception exception) {
            log.error("could not close session during rollback", exception);
        }
        try {
            if (this.newTransaction) {
                if (!this.commitFailed) {
                    this.userTransaction.rollback();
                    log.debug("Rolled back JTA UserTransaction");
                }
            } else {
                this.userTransaction.setRollbackOnly();
                log.debug("set JTA UserTransaction to rollback only");
            }
        }
        catch (Exception exception) {
            log.error("JTA rollback failed", exception);
            throw new TransactionException("JTA rollback failed", exception);
        }
        finally {
            this.afterCommitRollback();
        }
    }

    private void afterCommitRollback() throws TransactionException {
        this.begun = false;
        if (this.callback) {
            if (!this.newTransaction) {
                log.warn("You should set hibernate.transaction.manager_lookup_class if cache is enabled");
            }
            int n = Integer.MIN_VALUE;
            try {
                n = this.userTransaction.getStatus();
                this.jdbcContext.afterTransactionCompletion(n == 3, this);
            }
            catch (Exception exception) {
                try {
                    log.error("Could not determine transaction status after commit", exception);
                    throw new TransactionException("Could not determine transaction status after commit", exception);
                }
                catch (Throwable throwable) {
                    this.jdbcContext.afterTransactionCompletion(n == 3, this);
                    throw throwable;
                }
            }
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int n;
        try {
            n = this.userTransaction.getStatus();
        }
        catch (SystemException systemException) {
            log.error("Could not determine transaction status", systemException);
            throw new TransactionException("Could not determine transaction status", systemException);
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(n);
    }

    public boolean wasCommitted() throws TransactionException {
        int n;
        try {
            n = this.userTransaction.getStatus();
        }
        catch (SystemException systemException) {
            log.error("Could not determine transaction status", systemException);
            throw new TransactionException("Could not determine transaction status: ", systemException);
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 3;
    }

    public boolean isActive() throws TransactionException {
        int n;
        if (!this.begun || this.commitFailed || this.commitSucceeded) {
            return false;
        }
        try {
            n = this.userTransaction.getStatus();
        }
        catch (SystemException systemException) {
            log.error("Could not determine transaction status", systemException);
            throw new TransactionException("Could not determine transaction status: ", systemException);
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 0;
    }

    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        if (this.getTransactionManager() == null) {
            throw new IllegalStateException("JTA TransactionManager not available");
        }
        try {
            this.getTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception exception) {
            throw new TransactionException("could not register synchronization", exception);
        }
    }

    private TransactionManager getTransactionManager() {
        return this.transactionContext.getFactory().getTransactionManager();
    }

    private void closeIfRequired() throws HibernateException {
        boolean bl;
        boolean bl2 = bl = this.callback && this.transactionContext.shouldAutoClose() && !this.transactionContext.isClosed();
        if (bl) {
            this.transactionContext.managedClose();
        }
    }

    public void setTimeout(int n) {
        try {
            this.userTransaction.setTransactionTimeout(n);
        }
        catch (SystemException systemException) {
            throw new TransactionException("could not set transaction timeout", systemException);
        }
    }

    protected UserTransaction getUserTransaction() {
        return this.userTransaction;
    }
}

