/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JTATransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.JTAHelper;
import org.hibernate.util.NamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTATransactionFactory
implements TransactionFactory {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private static final Logger log = LoggerFactory.getLogger(JTATransactionFactory.class);
    protected InitialContext initialContext;
    protected String userTransactionName;

    public void configure(Properties properties) throws HibernateException {
        this.initialContext = this.resolveInitialContext(properties);
        this.userTransactionName = this.resolveUserTransactionName(properties);
        log.trace("Configured JTATransactionFactory to use [{}] for UserTransaction JDNI namespace", (Object)this.userTransactionName);
    }

    protected final InitialContext resolveInitialContext(Properties properties) {
        try {
            return NamingHelper.getInitialContext(properties);
        }
        catch (NamingException namingException) {
            throw new HibernateException("Could not obtain initial context", namingException);
        }
    }

    protected final String resolveUserTransactionName(Properties properties) {
        TransactionManagerLookup transactionManagerLookup;
        String string = properties.getProperty("jta.UserTransaction");
        if (string == null && (transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup(properties)) != null) {
            string = transactionManagerLookup.getUserTransactionName();
        }
        return string == null ? DEFAULT_USER_TRANSACTION_NAME : string;
    }

    public Transaction createTransaction(JDBCContext jDBCContext, TransactionFactory.Context context) throws HibernateException {
        UserTransaction userTransaction = this.getUserTransaction();
        return new JTATransaction(userTransaction, jDBCContext, context);
    }

    protected UserTransaction getUserTransaction() {
        String string = this.getUserTransactionName();
        log.trace("Attempting to locate UserTransaction via JNDI [{}]", (Object)string);
        try {
            UserTransaction userTransaction = (UserTransaction)this.getInitialContext().lookup(string);
            if (userTransaction == null) {
                throw new TransactionException("Naming service lookup for UserTransaction returned null [" + string + "]");
            }
            log.trace("Obtained UserTransaction");
            return userTransaction;
        }
        catch (NamingException namingException) {
            throw new TransactionException("Could not find UserTransaction in JNDI [" + string + "]", namingException);
        }
    }

    protected InitialContext getInitialContext() {
        return this.initialContext;
    }

    protected String getUserTransactionName() {
        return this.userTransactionName;
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public boolean isTransactionManagerRequired() {
        return false;
    }

    public boolean areCallbacksLocalToHibernateTransactions() {
        return false;
    }

    public boolean isTransactionInProgress(JDBCContext jDBCContext, TransactionFactory.Context context, Transaction transaction) {
        try {
            UserTransaction userTransaction;
            if (transaction != null && (userTransaction = ((JTATransaction)transaction).getUserTransaction()) != null) {
                return JTAHelper.isInProgress(userTransaction.getStatus());
            }
            if (jDBCContext.getFactory().getTransactionManager() != null) {
                return JTAHelper.isInProgress(jDBCContext.getFactory().getTransactionManager().getStatus());
            }
            userTransaction = this.getUserTransaction();
            return userTransaction != null && JTAHelper.isInProgress(userTransaction.getStatus());
        }
        catch (SystemException systemException) {
            throw new TransactionException("Unable to check transaction status", systemException);
        }
    }
}

