/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(TransactionFactoryFactory.class);

    public static TransactionFactory buildTransactionFactory(Properties properties) throws HibernateException {
        TransactionFactory transactionFactory;
        String string = properties.getProperty("hibernate.transaction.factory_class");
        if (string == null) {
            log.info("Using default transaction strategy (direct JDBC transactions)");
            return new JDBCTransactionFactory();
        }
        log.info("Transaction strategy: " + string);
        try {
            transactionFactory = (TransactionFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("TransactionFactory class not found", classNotFoundException);
            throw new HibernateException("TransactionFactory class not found: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.error("Failed to instantiate TransactionFactory", illegalAccessException);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            log.error("Failed to instantiate TransactionFactory", instantiationException);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + instantiationException);
        }
        transactionFactory.configure(properties);
        return transactionFactory;
    }

    private TransactionFactoryFactory() {
    }
}

