/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionManagerLookupFactory {
    private static final Logger log = LoggerFactory.getLogger(TransactionManagerLookupFactory.class);

    private TransactionManagerLookupFactory() {
    }

    public static TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        log.info("obtaining TransactionManager");
        return TransactionManagerLookupFactory.getTransactionManagerLookup(properties).getTransactionManager(properties);
    }

    public static TransactionManagerLookup getTransactionManagerLookup(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.transaction.manager_lookup_class");
        if (string == null) {
            log.info("No TransactionManagerLookup configured (in JTA environment, use of read-write or transactional second-level cache is not recommended)");
            return null;
        }
        log.info("instantiating TransactionManagerLookup: " + string);
        try {
            TransactionManagerLookup transactionManagerLookup = (TransactionManagerLookup)ReflectHelper.classForName(string).newInstance();
            log.info("instantiated TransactionManagerLookup");
            return transactionManagerLookup;
        }
        catch (Exception exception) {
            log.error("Could not instantiate TransactionManagerLookup", exception);
            throw new HibernateException("Could not instantiate TransactionManagerLookup '" + string + "'");
        }
    }
}

