/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction.synchronization;

import javax.transaction.SystemException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.synchronization.AfterCompletionAction;
import org.hibernate.transaction.synchronization.BeforeCompletionManagedFlushChecker;
import org.hibernate.transaction.synchronization.ExceptionMapper;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackCoordinator {
    private static final Logger log = LoggerFactory.getLogger(CallbackCoordinator.class);
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction jtaTransaction;
    private final Transaction hibernateTransaction;
    private BeforeCompletionManagedFlushChecker beforeCompletionManagedFlushChecker;
    private AfterCompletionAction afterCompletionAction;
    private ExceptionMapper exceptionMapper;
    private static final BeforeCompletionManagedFlushChecker STANDARD_MANAGED_FLUSH_CHECKER = new BeforeCompletionManagedFlushChecker(){

        public boolean shouldDoManagedFlush(TransactionFactory.Context context, javax.transaction.Transaction transaction) throws SystemException {
            return !context.isFlushModeNever() && context.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(transaction.getStatus());
        }
    };
    private static final ExceptionMapper STANDARD_EXCEPTION_MAPPER = new ExceptionMapper(){

        public RuntimeException mapStatusCheckFailure(String string, SystemException systemException) {
            log.error("could not determine transaction status [{}]", (Object)systemException.getMessage());
            return new TransactionException("could not determine transaction status in beforeCompletion()", systemException);
        }

        public RuntimeException mapManagedFlushFailure(String string, RuntimeException runtimeException) {
            log.error("Error during managed flush [{}]", (Object)runtimeException.getMessage());
            return runtimeException;
        }
    };
    private static final AfterCompletionAction STANDARD_AFTER_COMPLETION_ACTION = new AfterCompletionAction(){

        public void doAction(TransactionFactory.Context context, int n) {
        }
    };

    public CallbackCoordinator(TransactionFactory.Context context, JDBCContext jDBCContext, javax.transaction.Transaction transaction, Transaction transaction2) {
        this.ctx = context;
        this.jdbcContext = jDBCContext;
        this.jtaTransaction = transaction;
        this.hibernateTransaction = transaction2;
        this.reset();
    }

    public void reset() {
        this.beforeCompletionManagedFlushChecker = STANDARD_MANAGED_FLUSH_CHECKER;
        this.exceptionMapper = STANDARD_EXCEPTION_MAPPER;
        this.afterCompletionAction = STANDARD_AFTER_COMPLETION_ACTION;
    }

    public BeforeCompletionManagedFlushChecker getBeforeCompletionManagedFlushChecker() {
        return this.beforeCompletionManagedFlushChecker;
    }

    public void setBeforeCompletionManagedFlushChecker(BeforeCompletionManagedFlushChecker beforeCompletionManagedFlushChecker) {
        this.beforeCompletionManagedFlushChecker = beforeCompletionManagedFlushChecker;
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public AfterCompletionAction getAfterCompletionAction() {
        return this.afterCompletionAction;
    }

    public void setAfterCompletionAction(AfterCompletionAction afterCompletionAction) {
        this.afterCompletionAction = afterCompletionAction;
    }

    public void beforeCompletion() {
        boolean bl;
        log.trace("transaction before completion callback");
        try {
            bl = this.beforeCompletionManagedFlushChecker.shouldDoManagedFlush(this.ctx, this.jtaTransaction);
        }
        catch (SystemException systemException) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapStatusCheckFailure("could not determine transaction status in beforeCompletion()", systemException);
        }
        try {
            if (bl) {
                log.trace("automatically flushing session");
                this.ctx.managedFlush();
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapManagedFlushFailure("error during managed flush", runtimeException);
        }
        finally {
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
        }
    }

    private void setRollbackOnly() {
        try {
            this.jtaTransaction.setRollbackOnly();
        }
        catch (SystemException systemException) {
            log.error("could not set transaction to rollback only", systemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int n) {
        log.trace("transaction after completion callback [status={}]", n);
        try {
            this.afterCompletionAction.doAction(this.ctx, n);
            boolean bl = n == 3;
            this.jdbcContext.afterTransactionCompletion(bl, this.hibernateTransaction);
        }
        finally {
            this.reset();
            this.jdbcContext.cleanUpJtaSynchronizationCallbackCoordinator();
            if (this.ctx.shouldAutoClose() && !this.ctx.isClosed()) {
                log.trace("automatically closing session");
                this.ctx.managedClose();
            }
        }
    }
}

