/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Constructor;
import org.hibernate.EntityMode;
import org.hibernate.engine.IdentifierValue;
import org.hibernate.engine.UnsavedValueFactory;
import org.hibernate.engine.VersionValue;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.util.ReflectHelper;

public class PropertyFactory {
    public static IdentifierProperty buildIdentifierProperty(PersistentClass persistentClass, IdentifierGenerator identifierGenerator) {
        String string = persistentClass.getIdentifier().getNullValue();
        Type type = persistentClass.getIdentifier().getType();
        Property property = persistentClass.getIdentifierProperty();
        IdentifierValue identifierValue = UnsavedValueFactory.getUnsavedIdentifierValue(string, PropertyFactory.getGetter(property), type, PropertyFactory.getConstructor(persistentClass));
        if (property == null) {
            return new IdentifierProperty(type, persistentClass.hasEmbeddedIdentifier(), persistentClass.hasIdentifierMapper(), identifierValue, identifierGenerator);
        }
        return new IdentifierProperty(property.getName(), property.getNodeName(), type, persistentClass.hasEmbeddedIdentifier(), identifierValue, identifierGenerator);
    }

    public static VersionProperty buildVersionProperty(Property property, boolean bl) {
        String string = ((KeyValue)property.getValue()).getNullValue();
        VersionValue versionValue = UnsavedValueFactory.getUnsavedVersionValue(string, PropertyFactory.getGetter(property), (VersionType)property.getType(), PropertyFactory.getConstructor(property.getPersistentClass()));
        boolean bl2 = bl && property.isLazy();
        return new VersionProperty(property.getName(), property.getNodeName(), property.getValue().getType(), bl2, property.isInsertable(), property.isUpdateable(), property.getGeneration() == PropertyGeneration.INSERT || property.getGeneration() == PropertyGeneration.ALWAYS, property.getGeneration() == PropertyGeneration.ALWAYS, property.isOptional(), property.isUpdateable() && !bl2, property.isOptimisticLocked(), property.getCascadeStyle(), versionValue);
    }

    public static StandardProperty buildStandardProperty(Property property, boolean bl) {
        Type type = property.getValue().getType();
        boolean bl2 = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        return new StandardProperty(property.getName(), property.getNodeName(), type, bl && property.isLazy(), property.isInsertable(), property.isUpdateable(), property.getGeneration() == PropertyGeneration.INSERT || property.getGeneration() == PropertyGeneration.ALWAYS, property.getGeneration() == PropertyGeneration.ALWAYS, property.isOptional(), bl2 || property.isUpdateable(), property.isOptimisticLocked(), property.getCascadeStyle(), property.getValue().getFetchMode());
    }

    private static Constructor getConstructor(PersistentClass persistentClass) {
        if (persistentClass == null || !persistentClass.hasPojoRepresentation()) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(persistentClass.getMappedClass());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Getter getGetter(Property property) {
        if (property == null || !property.getPersistentClass().hasPojoRepresentation()) {
            return null;
        }
        PropertyAccessor propertyAccessor = PropertyAccessorFactory.getPropertyAccessor(property, EntityMode.POJO);
        return propertyAccessor.getGetter(property.getPersistentClass().getMappedClass(), property.getName());
    }
}

