/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.component.ComponentTuplizer;

public abstract class AbstractComponentTuplizer
implements ComponentTuplizer {
    protected final Getter[] getters;
    protected final Setter[] setters;
    protected final int propertySpan;
    protected final Instantiator instantiator;
    protected final boolean hasCustomAccessors;

    protected abstract Instantiator buildInstantiator(Component var1);

    protected abstract Getter buildGetter(Component var1, Property var2);

    protected abstract Setter buildSetter(Component var1, Property var2);

    protected AbstractComponentTuplizer(Component component) {
        this.propertySpan = component.getPropertySpan();
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        Iterator iterator = component.getPropertyIterator();
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            this.getters[n] = this.buildGetter(component, property);
            this.setters[n] = this.buildSetter(component, property);
            if (!property.isBasicPropertyAccessor()) {
                bl = true;
            }
            ++n;
        }
        this.hasCustomAccessors = bl;
        this.instantiator = this.buildInstantiator(component);
    }

    public Object getPropertyValue(Object object, int n) throws HibernateException {
        return this.getters[n].get(object);
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        Object[] objectArray = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            objectArray[i] = this.getPropertyValue(object, i);
        }
        return objectArray;
    }

    public boolean isInstance(Object object) {
        return this.instantiator.isInstance(object);
    }

    public void setPropertyValues(Object object, Object[] objectArray) throws HibernateException {
        for (int i = 0; i < this.propertySpan; ++i) {
            this.setters[i].set(object, objectArray[i], null);
        }
    }

    public Object instantiate() throws HibernateException {
        return this.instantiator.instantiate();
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasParentProperty() {
        return false;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public void setParent(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) {
        throw new UnsupportedOperationException();
    }

    public Getter getGetter(int n) {
        return this.getters[n];
    }
}

