/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.component.ComponentEntityModeToTuplizerMapping;

public class ComponentMetamodel
implements Serializable {
    private final String role;
    private final boolean isKey;
    private final StandardProperty[] properties;
    private final ComponentEntityModeToTuplizerMapping tuplizerMapping;
    private final int propertySpan;
    private final Map propertyIndexes = new HashMap();

    public ComponentMetamodel(Component component) {
        this.role = component.getRoleName();
        this.isKey = component.isKey();
        this.propertySpan = component.getPropertySpan();
        this.properties = new StandardProperty[this.propertySpan];
        Iterator iterator = component.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            this.properties[n] = PropertyFactory.buildStandardProperty(property, false);
            this.propertyIndexes.put(property.getName(), new Integer(n));
            ++n;
        }
        this.tuplizerMapping = new ComponentEntityModeToTuplizerMapping(component);
    }

    public boolean isKey() {
        return this.isKey;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public StandardProperty[] getProperties() {
        return this.properties;
    }

    public StandardProperty getProperty(int n) {
        if (n < 0 || n >= this.propertySpan) {
            throw new IllegalArgumentException("illegal index value for component property access [request=" + n + ", span=" + this.propertySpan + "]");
        }
        return this.properties[n];
    }

    public int getPropertyIndex(String string) {
        Integer n = (Integer)this.propertyIndexes.get(string);
        if (n == null) {
            throw new HibernateException("component does not contain such a property [" + string + "]");
        }
        return n;
    }

    public StandardProperty getProperty(String string) {
        return this.getProperty(this.getPropertyIndex(string));
    }

    public ComponentEntityModeToTuplizerMapping getTuplizerMapping() {
        return this.tuplizerMapping;
    }
}

