/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.Dom4jComponentTuplizer;
import org.hibernate.tuple.component.DynamicMapComponentTuplizer;
import org.hibernate.tuple.component.PojoComponentTuplizer;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTuplizerFactory
implements Serializable {
    private static final Class[] COMPONENT_TUP_CTOR_SIG = new Class[]{Component.class};
    private Map<EntityMode, Class<? extends ComponentTuplizer>> defaultImplClassByMode = ComponentTuplizerFactory.buildBaseMapping();

    public void registerDefaultTuplizerClass(EntityMode entityMode, Class<? extends ComponentTuplizer> clazz) {
        assert (this.isComponentTuplizerImplementor(clazz)) : "Specified tuplizer class [" + clazz.getName() + "] does not implement " + ComponentTuplizer.class.getName();
        assert (this.hasProperConstructor(clazz)) : "Specified tuplizer class [" + clazz.getName() + "] is not properly instantiatable";
        this.defaultImplClassByMode.put(entityMode, clazz);
    }

    public ComponentTuplizer constructTuplizer(String string, Component component) {
        try {
            Class clazz = ReflectHelper.classForName(string);
            return this.constructTuplizer(clazz, component);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Could not locate specified tuplizer class [" + string + "]");
        }
    }

    public ComponentTuplizer constructTuplizer(Class<? extends ComponentTuplizer> clazz, Component component) {
        Constructor<? extends ComponentTuplizer> constructor = this.getProperConstructor(clazz);
        assert (constructor != null) : "Unable to locate proper constructor for tuplizer [" + clazz.getName() + "]";
        try {
            return constructor.newInstance(component);
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to instantiate default tuplizer [" + clazz.getName() + "]", throwable);
        }
    }

    public ComponentTuplizer constructDefaultTuplizer(EntityMode entityMode, Component component) {
        Class<? extends ComponentTuplizer> clazz = this.defaultImplClassByMode.get(entityMode);
        if (clazz == null) {
            throw new HibernateException("could not determine default tuplizer class to use [" + entityMode + "]");
        }
        return this.constructTuplizer(clazz, component);
    }

    private boolean isComponentTuplizerImplementor(Class clazz) {
        return ReflectHelper.implementsInterface(clazz, ComponentTuplizer.class);
    }

    private boolean hasProperConstructor(Class clazz) {
        return this.getProperConstructor(clazz) != null;
    }

    private Constructor<? extends ComponentTuplizer> getProperConstructor(Class<? extends ComponentTuplizer> clazz) {
        Constructor<? extends ComponentTuplizer> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(COMPONENT_TUP_CTOR_SIG);
            if (!ReflectHelper.isPublic(constructor)) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    constructor = null;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    private static Map<EntityMode, Class<? extends ComponentTuplizer>> buildBaseMapping() {
        ConcurrentHashMap<EntityMode, Class<? extends ComponentTuplizer>> concurrentHashMap = new ConcurrentHashMap<EntityMode, Class<? extends ComponentTuplizer>>();
        concurrentHashMap.put(EntityMode.POJO, PojoComponentTuplizer.class);
        concurrentHashMap.put(EntityMode.DOM4J, Dom4jComponentTuplizer.class);
        concurrentHashMap.put(EntityMode.MAP, DynamicMapComponentTuplizer.class);
        return concurrentHashMap;
    }
}

