/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PersistEvent;
import org.hibernate.id.Assigned;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityTuplizer
implements EntityTuplizer {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityTuplizer.class);
    private final EntityMetamodel entityMetamodel;
    private final Getter idGetter;
    private final Setter idSetter;
    protected final Getter[] getters;
    protected final Setter[] setters;
    protected final int propertySpan;
    protected final boolean hasCustomAccessors;
    private final Instantiator instantiator;
    private final ProxyFactory proxyFactory;
    private final CompositeType identifierMapperType;
    private final MappedIdentifierValueMarshaller mappedIdentifierValueMarshaller;

    public Type getIdentifierMapperType() {
        return this.identifierMapperType;
    }

    protected abstract Getter buildPropertyGetter(Property var1, PersistentClass var2);

    protected abstract Setter buildPropertySetter(Property var1, PersistentClass var2);

    protected abstract Instantiator buildInstantiator(PersistentClass var1);

    protected abstract ProxyFactory buildProxyFactory(PersistentClass var1, Getter var2, Setter var3);

    public AbstractEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        MetaAttributable metaAttributable;
        this.entityMetamodel = entityMetamodel;
        if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
            this.idGetter = this.buildPropertyGetter(persistentClass.getIdentifierProperty(), persistentClass);
            this.idSetter = this.buildPropertySetter(persistentClass.getIdentifierProperty(), persistentClass);
        } else {
            this.idGetter = null;
            this.idSetter = null;
        }
        this.propertySpan = entityMetamodel.getPropertySpan();
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        Iterator iterator = persistentClass.getPropertyClosureIterator();
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            metaAttributable = (Property)iterator.next();
            this.getters[n] = this.buildPropertyGetter((Property)metaAttributable, persistentClass);
            this.setters[n] = this.buildPropertySetter((Property)metaAttributable, persistentClass);
            if (!((Property)metaAttributable).isBasicPropertyAccessor()) {
                bl = true;
            }
            ++n;
        }
        this.hasCustomAccessors = bl;
        this.instantiator = this.buildInstantiator(persistentClass);
        if (entityMetamodel.isLazy()) {
            this.proxyFactory = this.buildProxyFactory(persistentClass, this.idGetter, this.idSetter);
            if (this.proxyFactory == null) {
                entityMetamodel.setLazy(false);
            }
        } else {
            this.proxyFactory = null;
        }
        if ((metaAttributable = persistentClass.getIdentifierMapper()) == null) {
            this.identifierMapperType = null;
            this.mappedIdentifierValueMarshaller = null;
        } else {
            this.identifierMapperType = (CompositeType)((Component)metaAttributable).getType();
            this.mappedIdentifierValueMarshaller = AbstractEntityTuplizer.buildMappedIdentifierValueMarshaller((ComponentType)entityMetamodel.getIdentifierProperty().getType(), (ComponentType)this.identifierMapperType);
        }
    }

    protected String getEntityName() {
        return this.entityMetamodel.getName();
    }

    protected Set getSubclassEntityNames() {
        return this.entityMetamodel.getSubclassEntityNames();
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.getIdentifier(object, null);
    }

    public Serializable getIdentifier(Object object, SessionImplementor sessionImplementor) {
        Object object2;
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            object2 = object;
        } else if (this.idGetter == null) {
            if (this.identifierMapperType == null) {
                throw new HibernateException("The class has no identifier property: " + this.getEntityName());
            }
            object2 = this.mappedIdentifierValueMarshaller.getIdentifier(object, this.getEntityMode(), sessionImplementor);
        } else {
            object2 = this.idGetter.get(object);
        }
        try {
            return (Serializable)object2;
        }
        catch (ClassCastException classCastException) {
            StringBuffer stringBuffer = new StringBuffer("Identifier classes must be serializable. ");
            if (object2 != null) {
                stringBuffer.append(object2.getClass().getName()).append(" is not serializable. ");
            }
            if (classCastException.getMessage() != null) {
                stringBuffer.append(classCastException.getMessage());
            }
            throw new ClassCastException(stringBuffer.toString());
        }
    }

    public void setIdentifier(Object object, Serializable serializable) throws HibernateException {
        this.setIdentifier(object, serializable, null);
    }

    public void setIdentifier(Object object, Serializable serializable, SessionImplementor sessionImplementor) {
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            if (object != serializable) {
                CompositeType compositeType = (CompositeType)this.entityMetamodel.getIdentifierProperty().getType();
                compositeType.setPropertyValues(object, compositeType.getPropertyValues((Object)serializable, this.getEntityMode()), this.getEntityMode());
            }
        } else if (this.idSetter != null) {
            this.idSetter.set(object, serializable, this.getFactory());
        } else if (this.identifierMapperType != null) {
            this.mappedIdentifierValueMarshaller.setIdentifier(object, serializable, this.getEntityMode(), sessionImplementor);
        }
    }

    private static MappedIdentifierValueMarshaller buildMappedIdentifierValueMarshaller(ComponentType componentType, ComponentType componentType2) {
        boolean bl = true;
        for (int i = 0; i < componentType2.getSubtypes().length; ++i) {
            if (!componentType2.getSubtypes()[i].isEntityType() || componentType.getSubtypes()[i].isEntityType()) continue;
            bl = false;
            break;
        }
        return bl ? new NormalMappedIdentifierValueMarshaller(componentType2, componentType) : new IncrediblySillyJpaMapsIdMappedIdentifierValueMarshaller(componentType2, componentType);
    }

    public void resetIdentifier(Object object, Serializable serializable, Object object2) {
        this.resetIdentifier(object, serializable, object2, null);
    }

    public void resetIdentifier(Object object, Serializable serializable, Object object2, SessionImplementor sessionImplementor) {
        if (!(this.entityMetamodel.getIdentifierProperty().getIdentifierGenerator() instanceof Assigned)) {
            Serializable serializable2 = this.entityMetamodel.getIdentifierProperty().getUnsavedValue().getDefaultValue(serializable);
            this.setIdentifier(object, serializable2, sessionImplementor);
            VersionProperty versionProperty = this.entityMetamodel.getVersionProperty();
            if (this.entityMetamodel.isVersioned()) {
                this.setPropertyValue(object, this.entityMetamodel.getVersionPropertyIndex(), versionProperty.getUnsavedValue().getDefaultValue(object2));
            }
        }
    }

    public Object getVersion(Object object) throws HibernateException {
        if (!this.entityMetamodel.isVersioned()) {
            return null;
        }
        return this.getters[this.entityMetamodel.getVersionPropertyIndex()].get(object);
    }

    protected boolean shouldGetAllProperties(Object object) {
        return !this.hasUninitializedLazyProperties(object);
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        boolean bl = this.shouldGetAllProperties(object);
        int n = this.entityMetamodel.getPropertySpan();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            StandardProperty standardProperty = this.entityMetamodel.getProperties()[i];
            objectArray[i] = bl || !standardProperty.isLazy() ? this.getters[i].get(object) : LazyPropertyInitializer.UNFETCHED_PROPERTY;
        }
        return objectArray;
    }

    public Object[] getPropertyValuesToInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        int n = this.entityMetamodel.getPropertySpan();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getters[i].getForInsert(object, map, sessionImplementor);
        }
        return objectArray;
    }

    public Object getPropertyValue(Object object, int n) throws HibernateException {
        return this.getters[n].get(object);
    }

    public Object getPropertyValue(Object object, String string) throws HibernateException {
        int n = string.indexOf(46);
        String string2 = n > 0 ? string.substring(0, n) : string;
        Integer n2 = this.entityMetamodel.getPropertyIndexOrNull(string2);
        if (n2 == null) {
            string = "_identifierMapper." + string;
            n = string.indexOf(46);
            string2 = n > 0 ? string.substring(0, n) : string;
        }
        n2 = this.entityMetamodel.getPropertyIndexOrNull(string2);
        Object object2 = this.getPropertyValue(object, n2);
        if (n > 0) {
            if (object2 == null) {
                return null;
            }
            return this.getComponentValue((ComponentType)this.entityMetamodel.getPropertyTypes()[n2], object2, string.substring(n + 1));
        }
        return object2;
    }

    protected Object getComponentValue(ComponentType componentType, Object object, String string) {
        int n = string.indexOf(46);
        String string2 = n > 0 ? string.substring(0, n) : string;
        int n2 = this.findSubPropertyIndex(componentType, string2);
        Object object2 = componentType.getPropertyValue(object, n2, this.getEntityMode());
        if (n > 0) {
            if (object2 == null) {
                return null;
            }
            return this.getComponentValue((ComponentType)componentType.getSubtypes()[n2], object2, string.substring(n + 1));
        }
        return object2;
    }

    private int findSubPropertyIndex(ComponentType componentType, String string) {
        String[] stringArray = componentType.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        throw new MappingException("component property not found: " + string);
    }

    public void setPropertyValues(Object object, Object[] objectArray) throws HibernateException {
        boolean bl = !this.entityMetamodel.hasLazyProperties();
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!bl && objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) continue;
            this.setters[i].set(object, objectArray[i], this.getFactory());
        }
    }

    public void setPropertyValue(Object object, int n, Object object2) throws HibernateException {
        this.setters[n].set(object, object2, this.getFactory());
    }

    public void setPropertyValue(Object object, String string, Object object2) throws HibernateException {
        this.setters[this.entityMetamodel.getPropertyIndex(string)].set(object, object2, this.getFactory());
    }

    public final Object instantiate(Serializable serializable) throws HibernateException {
        return this.instantiate(serializable, null);
    }

    public final Object instantiate(Serializable serializable, SessionImplementor sessionImplementor) {
        Object object = this.getInstantiator().instantiate(serializable);
        if (serializable != null) {
            this.setIdentifier(object, serializable, sessionImplementor);
        }
        return object;
    }

    public final Object instantiate() throws HibernateException {
        return this.instantiate(null, null);
    }

    public void afterInitialize(Object object, boolean bl, SessionImplementor sessionImplementor) {
    }

    public boolean hasUninitializedLazyProperties(Object object) {
        return false;
    }

    public final boolean isInstance(Object object) {
        return this.getInstantiator().isInstance(object);
    }

    public boolean hasProxy() {
        return this.entityMetamodel.isLazy();
    }

    public final Object createProxy(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getProxyFactory().getProxy(serializable, sessionImplementor);
    }

    public boolean isLifecycleImplementor() {
        return false;
    }

    public boolean isValidatableImplementor() {
        return false;
    }

    protected final EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    protected final SessionFactoryImplementor getFactory() {
        return this.entityMetamodel.getSessionFactory();
    }

    protected final Instantiator getInstantiator() {
        return this.instantiator;
    }

    protected final ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getEntityMetamodel().getName() + ')';
    }

    public Getter getIdentifierGetter() {
        return this.idGetter;
    }

    public Getter getVersionGetter() {
        if (this.getEntityMetamodel().isVersioned()) {
            return this.getGetter(this.getEntityMetamodel().getVersionPropertyIndex());
        }
        return null;
    }

    public Getter getGetter(int n) {
        return this.getters[n];
    }

    private static class IncrediblySillyJpaMapsIdMappedIdentifierValueMarshaller
    implements MappedIdentifierValueMarshaller {
        private final ComponentType virtualIdComponent;
        private final ComponentType mappedIdentifierType;

        private IncrediblySillyJpaMapsIdMappedIdentifierValueMarshaller(ComponentType componentType, ComponentType componentType2) {
            this.virtualIdComponent = componentType;
            this.mappedIdentifierType = componentType2;
        }

        public Object getIdentifier(Object object, EntityMode entityMode, SessionImplementor sessionImplementor) {
            Object object2 = this.mappedIdentifierType.instantiate(entityMode);
            Object[] objectArray = this.virtualIdComponent.getPropertyValues(object, entityMode);
            Type[] typeArray = this.virtualIdComponent.getSubtypes();
            Type[] typeArray2 = this.mappedIdentifierType.getSubtypes();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Serializable serializable;
                if (objectArray[i] == null) {
                    throw new HibernateException("No part of a composite identifier may be null");
                }
                if (!typeArray[i].isAssociationType() || typeArray2[i].isAssociationType()) continue;
                if (sessionImplementor == null) {
                    throw new AssertionError((Object)"Deprecated version of getIdentifier (no session) was used but session was required");
                }
                if (HibernateProxy.class.isInstance(objectArray[i])) {
                    serializable = ((HibernateProxy)objectArray[i]).getHibernateLazyInitializer().getIdentifier();
                } else {
                    EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(objectArray[i]);
                    if (entityEntry != null) {
                        serializable = entityEntry.getId();
                    } else {
                        log.debug("Performing implicit derived identity cascade");
                        PersistEvent persistEvent = new PersistEvent(null, objectArray[i], (EventSource)sessionImplementor);
                        for (int j = 0; j < sessionImplementor.getListeners().getPersistEventListeners().length; ++j) {
                            sessionImplementor.getListeners().getPersistEventListeners()[j].onPersist(persistEvent);
                        }
                        entityEntry = sessionImplementor.getPersistenceContext().getEntry(objectArray[i]);
                        if (entityEntry == null || entityEntry.getId() == null) {
                            throw new HibernateException("Unable to process implicit derived identity cascade");
                        }
                        serializable = entityEntry.getId();
                    }
                }
                objectArray[i] = serializable;
            }
            this.mappedIdentifierType.setPropertyValues(object2, objectArray, entityMode);
            return object2;
        }

        public void setIdentifier(Object object, Serializable serializable, EntityMode entityMode, SessionImplementor sessionImplementor) {
            Object[] objectArray = this.mappedIdentifierType.getPropertyValues((Object)serializable, entityMode);
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < this.virtualIdComponent.getSubtypes().length; ++i) {
                Type type = this.virtualIdComponent.getSubtypes()[i];
                Type type2 = this.mappedIdentifierType.getSubtypes()[i];
                if (type.isEntityType() && !type2.isEntityType()) {
                    if (sessionImplementor == null) {
                        throw new AssertionError((Object)"Deprecated version of getIdentifier (no session) was used but session was required");
                    }
                    String string = ((EntityType)type).getAssociatedEntityName();
                    EntityKey entityKey = new EntityKey((Serializable)objectArray[i], sessionImplementor.getFactory().getEntityPersister(string), entityMode);
                    Object object2 = sessionImplementor.getPersistenceContext().getProxy(entityKey);
                    if (object2 == null) {
                        object2 = sessionImplementor.getPersistenceContext().getEntity(entityKey);
                    }
                    objectArray2[i] = object2;
                    continue;
                }
                objectArray2[i] = objectArray[i];
            }
            this.virtualIdComponent.setPropertyValues(object, objectArray2, sessionImplementor.getEntityMode());
        }
    }

    private static class NormalMappedIdentifierValueMarshaller
    implements MappedIdentifierValueMarshaller {
        private final ComponentType virtualIdComponent;
        private final ComponentType mappedIdentifierType;

        private NormalMappedIdentifierValueMarshaller(ComponentType componentType, ComponentType componentType2) {
            this.virtualIdComponent = componentType;
            this.mappedIdentifierType = componentType2;
        }

        public Object getIdentifier(Object object, EntityMode entityMode, SessionImplementor sessionImplementor) {
            Object object2 = this.mappedIdentifierType.instantiate(entityMode);
            Object[] objectArray = this.virtualIdComponent.getPropertyValues(object, entityMode);
            this.mappedIdentifierType.setPropertyValues(object2, objectArray, entityMode);
            return object2;
        }

        public void setIdentifier(Object object, Serializable serializable, EntityMode entityMode, SessionImplementor sessionImplementor) {
            this.virtualIdComponent.setPropertyValues(object, this.mappedIdentifierType.getPropertyValues((Object)serializable, sessionImplementor), entityMode);
        }
    }

    private static interface MappedIdentifierValueMarshaller {
        public Object getIdentifier(Object var1, EntityMode var2, SessionImplementor var3);

        public void setIdentifier(Object var1, Serializable var2, EntityMode var3, SessionImplementor var4);
    }
}

