/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.dom4j.Dom4jProxyFactory;
import org.hibernate.tuple.Dom4jInstantiator;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dom4jEntityTuplizer
extends AbstractEntityTuplizer {
    static final Logger log = LoggerFactory.getLogger(Dom4jEntityTuplizer.class);
    private Map inheritenceNodeNameMap = new HashMap();

    Dom4jEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        super(entityMetamodel, persistentClass);
        this.inheritenceNodeNameMap.put(persistentClass.getNodeName(), persistentClass.getEntityName());
        Iterator iterator = persistentClass.getSubclassClosureIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass2 = (PersistentClass)iterator.next();
            this.inheritenceNodeNameMap.put(persistentClass2.getNodeName(), persistentClass2.getEntityName());
        }
    }

    public EntityMode getEntityMode() {
        return EntityMode.DOM4J;
    }

    private PropertyAccessor buildPropertyAccessor(Property property) {
        if (property.isBackRef()) {
            return property.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDom4jPropertyAccessor(property.getNodeName(), property.getType(), this.getEntityMetamodel().getSessionFactory());
    }

    protected Getter buildPropertyGetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getGetter(null, property.getName());
    }

    protected Setter buildPropertySetter(Property property, PersistentClass persistentClass) {
        return this.buildPropertyAccessor(property).getSetter(null, property.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new Dom4jInstantiator(persistentClass);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.getIdentifier(object, null);
    }

    public Serializable getIdentifier(Object object, SessionImplementor sessionImplementor) {
        if (object instanceof Element) {
            return super.getIdentifier(object, sessionImplementor);
        }
        return (Serializable)object;
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter getter, Setter setter) {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(HibernateProxy.class);
        hashSet.add(Element.class);
        Dom4jProxyFactory dom4jProxyFactory = new Dom4jProxyFactory();
        try {
            dom4jProxyFactory.postInstantiate(this.getEntityName(), Element.class, hashSet, null, null, persistentClass.hasEmbeddedIdentifier() ? (CompositeType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException hibernateException) {
            log.warn("could not create proxy factory for:" + this.getEntityName(), hibernateException);
            dom4jProxyFactory = null;
        }
        return dom4jProxyFactory;
    }

    public Class getMappedClass() {
        return Element.class;
    }

    public Class getConcreteProxyClass() {
        return Element.class;
    }

    public boolean isInstrumented() {
        return false;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return new EntityNameResolver[]{new BasicEntityNameResolver(this.getEntityName(), this.inheritenceNodeNameMap)};
    }

    public String determineConcreteSubclassEntityName(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return (String)this.inheritenceNodeNameMap.get(Dom4jEntityTuplizer.extractNodeName((Element)object));
    }

    public static String extractNodeName(Element element) {
        return element.getName();
    }

    public static class BasicEntityNameResolver
    implements EntityNameResolver {
        private final String rootEntityName;
        private final Map nodeNameToEntityNameMap;

        public BasicEntityNameResolver(String string, Map map) {
            this.rootEntityName = string;
            this.nodeNameToEntityNameMap = map;
        }

        public String resolveEntityName(Object object) {
            return (String)this.nodeNameToEntityNameMap.get(Dom4jEntityTuplizer.extractNodeName((Element)object));
        }

        public boolean equals(Object object) {
            return this.rootEntityName.equals(((BasicEntityNameResolver)object).rootEntityName);
        }

        public int hashCode() {
            return this.rootEntityName.hashCode();
        }
    }
}

