/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoEntityTuplizer
extends AbstractEntityTuplizer {
    static final Logger log = LoggerFactory.getLogger(PojoEntityTuplizer.class);
    private final Class mappedClass;
    private final Class proxyInterface;
    private final boolean lifecycleImplementor;
    private final boolean validatableImplementor;
    private final Set lazyPropertyNames = new HashSet();
    private final ReflectionOptimizer optimizer;

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass persistentClass) {
        super(entityMetamodel, persistentClass);
        String[] stringArray;
        this.mappedClass = persistentClass.getMappedClass();
        this.proxyInterface = persistentClass.getProxyInterface();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        this.validatableImplementor = Validatable.class.isAssignableFrom(this.mappedClass);
        Iterator iterator = persistentClass.getPropertyClosureIterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (!stringArray.isLazy()) continue;
            this.lazyPropertyNames.add(stringArray.getName());
        }
        stringArray = new String[this.propertySpan];
        String[] stringArray2 = new String[this.propertySpan];
        Class[] classArray = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            stringArray[i] = this.getters[i].getMethodName();
            stringArray2[i] = this.setters[i].getMethodName();
            classArray[i] = this.getters[i].getReturnType();
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.mappedClass, stringArray, stringArray2, classArray);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter getter, Setter setter) {
        Method method;
        Object object;
        Class clazz;
        Object object2;
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(HibernateProxy.class);
        Class clazz2 = persistentClass.getMappedClass();
        Class clazz3 = persistentClass.getProxyInterface();
        if (clazz3 != null && !clazz2.equals(clazz3)) {
            if (!clazz3.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            hashSet.add(clazz3);
        }
        if (clazz2.isInterface()) {
            hashSet.add(clazz2);
        }
        Iterator iterator = persistentClass.getSubclassIterator();
        while (iterator.hasNext()) {
            object2 = (Subclass)iterator.next();
            clazz = ((PersistentClass)object2).getProxyInterface();
            object = ((PersistentClass)object2).getMappedClass();
            if (clazz == null || object.equals(clazz)) continue;
            if (!clazz.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + ((PersistentClass)object2).getEntityName());
            }
            hashSet.add(clazz);
        }
        object2 = persistentClass.getPropertyIterator();
        clazz = persistentClass.getMappedClass();
        while (object2.hasNext()) {
            object = (Property)object2.next();
            method = ((Property)object).getGetter(clazz).getMethod();
            if (method != null && Modifier.isFinal(method.getModifiers())) {
                log.error("Getters of lazy classes cannot be final: " + persistentClass.getEntityName() + "." + ((Property)object).getName());
            }
            if ((method = ((Property)object).getSetter(clazz).getMethod()) == null || !Modifier.isFinal(method.getModifiers())) continue;
            log.error("Setters of lazy classes cannot be final: " + persistentClass.getEntityName() + "." + ((Property)object).getName());
        }
        object = getter == null ? null : getter.getMethod();
        method = setter == null ? null : setter.getMethod();
        Method method2 = object == null || clazz3 == null ? null : ReflectHelper.getMethod(clazz3, (Method)object);
        Method method3 = method == null || clazz3 == null ? null : ReflectHelper.getMethod(clazz3, method);
        ProxyFactory proxyFactory = this.buildProxyFactoryInternal(persistentClass, getter, setter);
        try {
            proxyFactory.postInstantiate(this.getEntityName(), clazz2, hashSet, method2, method3, persistentClass.hasEmbeddedIdentifier() ? (CompositeType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException hibernateException) {
            log.warn("could not create proxy factory for:" + this.getEntityName(), hibernateException);
            proxyFactory = null;
        }
        return proxyFactory;
    }

    protected ProxyFactory buildProxyFactoryInternal(PersistentClass persistentClass, Getter getter, Setter setter) {
        return Environment.getBytecodeProvider().getProxyFactoryFactory().buildProxyFactory();
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        if (this.optimizer == null) {
            return new PojoInstantiator(persistentClass, null);
        }
        return new PojoInstantiator(persistentClass, this.optimizer.getInstantiationOptimizer());
    }

    public void setPropertyValues(Object object, Object[] objectArray) throws HibernateException {
        if (!this.getEntityMetamodel().hasLazyProperties() && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            this.setPropertyValuesWithOptimizer(object, objectArray);
        } else {
            super.setPropertyValues(object, objectArray);
        }
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        if (this.shouldGetAllProperties(object) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(object);
        }
        return super.getPropertyValues(object);
    }

    public Object[] getPropertyValuesToInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.shouldGetAllProperties(object) && this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.getPropertyValuesWithOptimizer(object);
        }
        return super.getPropertyValuesToInsert(object, map, sessionImplementor);
    }

    protected void setPropertyValuesWithOptimizer(Object object, Object[] objectArray) {
        this.optimizer.getAccessOptimizer().setPropertyValues(object, objectArray);
    }

    protected Object[] getPropertyValuesWithOptimizer(Object object) {
        return this.optimizer.getAccessOptimizer().getPropertyValues(object);
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    public boolean isValidatableImplementor() {
        return this.validatableImplementor;
    }

    protected Getter buildPropertyGetter(Property property, PersistentClass persistentClass) {
        return property.getGetter(persistentClass.getMappedClass());
    }

    protected Setter buildPropertySetter(Property property, PersistentClass persistentClass) {
        return property.getSetter(persistentClass.getMappedClass());
    }

    public Class getConcreteProxyClass() {
        return this.proxyInterface;
    }

    public void afterInitialize(Object object, boolean bl, SessionImplementor sessionImplementor) {
        if (this.isInstrumented()) {
            Set set = bl && this.getEntityMetamodel().hasLazyProperties() ? this.lazyPropertyNames : null;
            FieldInterceptionHelper.injectFieldInterceptor(object, this.getEntityName(), set, sessionImplementor);
        }
    }

    public boolean hasUninitializedLazyProperties(Object object) {
        if (this.getEntityMetamodel().hasLazyProperties()) {
            FieldInterceptor fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object);
            return fieldInterceptor != null && !fieldInterceptor.isInitialized();
        }
        return false;
    }

    public boolean isInstrumented() {
        return FieldInterceptionHelper.isInstrumented(this.getMappedClass());
    }

    public String determineConcreteSubclassEntityName(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        Class<?> clazz = object.getClass();
        if (clazz == this.getMappedClass()) {
            return this.getEntityName();
        }
        String string = this.getEntityMetamodel().findEntityNameByEntityClass(clazz);
        if (string == null) {
            throw new HibernateException("Unable to resolve entity name from Class [" + clazz.getName() + "]" + " expected instance/subclass of [" + this.getEntityName() + "]");
        }
        return string;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return null;
    }
}

