/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.MutableType;

public abstract class AbstractCharArrayType
extends MutableType {
    protected abstract Object toExternalFormat(char[] var1);

    protected abstract char[] toInternalFormat(Object var1);

    public Object get(ResultSet resultSet, String string) throws SQLException {
        Reader reader = resultSet.getCharacterStream(string);
        if (reader == null) {
            return this.toExternalFormat(null);
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        try {
            while (true) {
                int n;
                if ((n = reader.read()) == -1) {
                    return this.toExternalFormat(charArrayWriter.toCharArray());
                }
                charArrayWriter.write(n);
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("Unable to read character stream from rs");
        }
    }

    public abstract Class getReturnedClass();

    public void set(PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        char[] cArray = this.toInternalFormat(object);
        preparedStatement.setCharacterStream(n, (Reader)new CharArrayReader(cArray), cArray.length);
    }

    public int sqlType() {
        return 12;
    }

    public String objectToSQLString(Object object, Dialect dialect) throws Exception {
        return '\'' + new String(this.toInternalFormat(object)) + '\'';
    }

    public Object stringToObject(String string) throws Exception {
        if (string == null) {
            return this.toExternalFormat(null);
        }
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = string.charAt(i);
        }
        return this.toExternalFormat(cArray);
    }

    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        return new String(this.toInternalFormat(object));
    }

    public Object fromStringValue(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = string.charAt(i);
        }
        return this.toExternalFormat(cArray);
    }

    protected Object deepCopyNotNull(Object object) throws HibernateException {
        char[] cArray = this.toInternalFormat(object);
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return this.toExternalFormat(cArray2);
    }
}

