/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;

public abstract class AbstractLongStringType
extends ImmutableType {
    public void set(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        String string = (String)object;
        preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
    }

    public Object get(ResultSet resultSet, String string) throws HibernateException, SQLException {
        Reader reader = resultSet.getCharacterStream(string);
        if (reader == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading text", iOException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new HibernateException("IOException occurred closing stream", iOException);
            }
        }
        return stringBuffer.toString();
    }

    public Class getReturnedClass() {
        return String.class;
    }

    public String toString(Object object) {
        return (String)object;
    }

    public Object fromStringValue(String string) {
        return string;
    }
}

