/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class AnyType
extends AbstractType
implements CompositeType,
AssociationType {
    private final Type identifierType;
    private final Type metaType;
    private static final String[] PROPERTY_NAMES = new String[]{"class", "id"};

    public AnyType(Type type, Type type2) {
        this.identifierType = type2;
        this.metaType = type;
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public boolean isSame(Object object, Object object2, EntityMode entityMode) throws HibernateException {
        return object == object2;
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return 0;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return 2;
    }

    public String getName() {
        return "object";
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        throw new UnsupportedOperationException("object is a multicolumn type");
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.resolveAny((String)this.metaType.nullSafeGet(resultSet, stringArray[0], sessionImplementor, object), (Serializable)this.identifierType.nullSafeGet(resultSet, stringArray[1], sessionImplementor, object), sessionImplementor);
    }

    public Object hydrate(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        String string = (String)this.metaType.nullSafeGet(resultSet, stringArray[0], sessionImplementor, object);
        Serializable serializable = (Serializable)this.identifierType.nullSafeGet(resultSet, stringArray[1], sessionImplementor, object);
        return new ObjectTypeCacheEntry(string, serializable);
    }

    public Object resolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        ObjectTypeCacheEntry objectTypeCacheEntry = (ObjectTypeCacheEntry)object;
        return this.resolveAny(objectTypeCacheEntry.entityName, objectTypeCacheEntry.id, sessionImplementor);
    }

    public Object semiResolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        throw new UnsupportedOperationException("any mappings may not form part of a property-ref");
    }

    private Object resolveAny(String string, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        return string == null || serializable == null ? null : sessionImplementor.internalLoad(string, serializable, false, false);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.nullSafeSet(preparedStatement, object, n, null, sessionImplementor);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        String string;
        Serializable serializable;
        if (object == null) {
            serializable = null;
            string = null;
        } else {
            string = sessionImplementor.bestGuessEntityName(object);
            serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, object, sessionImplementor);
        }
        if (blArray == null || blArray[0]) {
            this.metaType.nullSafeSet(preparedStatement, string, n, sessionImplementor);
        }
        if (blArray == null) {
            this.identifierType.nullSafeSet(preparedStatement, serializable, n + 1, sessionImplementor);
        } else {
            boolean[] blArray2 = new boolean[blArray.length - 1];
            System.arraycopy(blArray, 1, blArray2, 0, blArray2.length);
            this.identifierType.nullSafeSet(preparedStatement, serializable, n + 1, blArray2, sessionImplementor);
        }
    }

    public Class getReturnedClass() {
        return Object.class;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return ArrayHelper.join(this.metaType.sqlTypes(mapping), this.identifierType.sqlTypes(mapping));
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        throw new UnsupportedOperationException("any types cannot be stringified");
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object == null ? "null" : Hibernate.entity(HibernateProxyHelper.getClassWithoutInitializingProxy(object)).toLoggableString(object, sessionFactoryImplementor);
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        ObjectTypeCacheEntry objectTypeCacheEntry = (ObjectTypeCacheEntry)serializable;
        return objectTypeCacheEntry == null ? null : sessionImplementor.internalLoad(objectTypeCacheEntry.entityName, objectTypeCacheEntry.id, false, false);
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return object == null ? null : new ObjectTypeCacheEntry(sessionImplementor.bestGuessEntityName(object), ForeignKeys.getEntityIdentifierIfNotUnsaved(sessionImplementor.bestGuessEntityName(object), object, sessionImplementor));
    }

    public boolean isAnyType() {
        return true;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        if (object == null) {
            return null;
        }
        String string = sessionImplementor.bestGuessEntityName(object);
        Serializable serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, object, sessionImplementor);
        return sessionImplementor.internalLoad(string, serializable, false, false);
    }

    public CascadeStyle getCascadeStyle(int n) {
        return CascadeStyle.NONE;
    }

    public FetchMode getFetchMode(int n) {
        return FetchMode.SELECT;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Object getPropertyValue(Object object, int n, SessionImplementor sessionImplementor) throws HibernateException {
        return n == 0 ? sessionImplementor.bestGuessEntityName(object) : this.getIdentifier(object, sessionImplementor);
    }

    public Object[] getPropertyValues(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        return new Object[]{sessionImplementor.bestGuessEntityName(object), this.getIdentifier(object, sessionImplementor)};
    }

    private Serializable getIdentifier(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        try {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(sessionImplementor.bestGuessEntityName(object), object, sessionImplementor);
        }
        catch (TransientObjectException transientObjectException) {
            return null;
        }
    }

    public Type[] getSubtypes() {
        return new Type[]{this.metaType, this.identifierType};
    }

    public void setPropertyValues(Object object, Object[] objectArray, EntityMode entityMode) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Object[] getPropertyValues(Object object, EntityMode entityMode) {
        throw new UnsupportedOperationException();
    }

    public boolean isComponentType() {
        return true;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT;
    }

    public boolean isAssociationType() {
        return true;
    }

    public boolean useLHSPrimaryKey() {
        return false;
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor sessionFactoryImplementor) {
        throw new UnsupportedOperationException("any types do not have a unique referenced persister");
    }

    public boolean isModified(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        if (object2 == null) {
            return object != null;
        }
        if (object == null) {
            return object2 != null;
        }
        ObjectTypeCacheEntry objectTypeCacheEntry = (ObjectTypeCacheEntry)object;
        boolean[] blArray2 = new boolean[blArray.length - 1];
        System.arraycopy(blArray, 1, blArray2, 0, blArray2.length);
        return blArray[0] && !objectTypeCacheEntry.entityName.equals(sessionImplementor.bestGuessEntityName(object2)) || this.identifierType.isModified(objectTypeCacheEntry.id, this.getIdentifier(object2, sessionImplementor), blArray2, sessionImplementor);
    }

    public String getAssociatedEntityName(SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        throw new UnsupportedOperationException("any types do not have a unique referenced persister");
    }

    public boolean[] getPropertyNullability() {
        return null;
    }

    public String getOnCondition(String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceToPrimaryKey() {
        return true;
    }

    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    public String getLHSPropertyName() {
        return null;
    }

    public boolean isAlwaysDirtyChecked() {
        return false;
    }

    public boolean isEmbeddedInXML() {
        return false;
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        boolean[] blArray = new boolean[this.getColumnSpan(mapping)];
        if (object != null) {
            Arrays.fill(blArray, true);
        }
        return blArray;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return this.isDirty(object, object2, sessionImplementor);
    }

    public boolean isEmbedded() {
        return false;
    }

    public static final class ObjectTypeCacheEntry
    implements Serializable {
        String entityName;
        Serializable id;

        ObjectTypeCacheEntry(String string, Serializable serializable) {
            this.entityName = string;
            this.id = serializable;
        }
    }
}

