/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentArrayHolder;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class ArrayType
extends CollectionType {
    private final Class elementClass;
    private final Class arrayClass;

    public ArrayType(TypeFactory.TypeScope typeScope, String string, String string2, Class clazz, boolean bl) {
        super(typeScope, string, string2, bl);
        this.elementClass = clazz;
        this.arrayClass = Array.newInstance(clazz, 0).getClass();
    }

    public Class getReturnedClass() {
        return this.arrayClass;
    }

    public PersistentCollection instantiate(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) throws HibernateException {
        return new PersistentArrayHolder(sessionImplementor, collectionPersister);
    }

    public Iterator getElementsIterator(Object object) {
        return Arrays.asList((Object[])object).iterator();
    }

    public PersistentCollection wrap(SessionImplementor sessionImplementor, Object object) {
        return new PersistentArrayHolder(sessionImplementor, object);
    }

    public boolean isArrayType() {
        return true;
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return "null";
        }
        int n = Array.getLength(object);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        Type type = this.getElementType(sessionFactoryImplementor);
        for (int i = 0; i < n; ++i) {
            arrayList.add(type.toLoggableString(Array.get(object, i), sessionFactoryImplementor));
        }
        return ((Object)arrayList).toString();
    }

    public Object instantiateResult(Object object) {
        return Array.newInstance(this.elementClass, Array.getLength(object));
    }

    public Object replaceElements(Object object, Object object2, Object object3, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        int n = Array.getLength(object);
        if (n != Array.getLength(object2)) {
            object2 = this.instantiateResult(object);
        }
        Type type = this.getElementType(sessionImplementor.getFactory());
        for (int i = 0; i < n; ++i) {
            Array.set(object2, i, type.replace(Array.get(object, i), null, sessionImplementor, object3, map));
        }
        return object2;
    }

    public Object instantiate(int n) {
        throw new UnsupportedOperationException();
    }

    public Object indexOf(Object object, Object object2) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            if (Array.get(object, i) != object2) continue;
            return new Integer(i);
        }
        return null;
    }

    protected boolean initializeImmediately(EntityMode entityMode) {
        return true;
    }

    public boolean hasHolder(EntityMode entityMode) {
        return true;
    }
}

