/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractLobType;
import org.hibernate.util.ArrayHelper;

@Deprecated
public class ByteArrayBlobType
extends AbstractLobType {
    private static final int[] TYPES = new int[]{2004};

    public int[] sqlTypes(Mapping mapping) {
        return TYPES;
    }

    public boolean isEqual(Object object, Object object2, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Byte[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            return ArrayHelper.isEquals(objectArray, objectArray2);
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        return ArrayHelper.isEquals(byArray, byArray2);
    }

    public int getHashCode(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        if (object instanceof Character[]) {
            Object[] objectArray = (Object[])object;
            return ArrayHelper.hash(objectArray);
        }
        byte[] byArray = (byte[])object;
        return ArrayHelper.hash(byArray);
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (object == null) {
            return null;
        }
        if (object instanceof Byte[]) {
            Byte[] byteArray = (Byte[])object;
            int n = byteArray.length;
            Byte[] byteArray2 = new Byte[n];
            for (int i = 0; i < n; ++i) {
                byteArray2[i] = (byte)byteArray[i];
            }
            return byteArray2;
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public Class getReturnedClass() {
        return Byte[].class;
    }

    protected Object get(ResultSet resultSet, String string) throws SQLException {
        Blob blob = resultSet.getBlob(string);
        if (resultSet.wasNull()) {
            return null;
        }
        int n = (int)blob.length();
        byte[] byArray = blob.getBytes(1L, n);
        return this.wrap(byArray);
    }

    protected void set(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, this.sqlTypes(null)[0]);
        } else {
            byte[] byArray = this.unWrap(object);
            boolean bl = sessionImplementor.getFactory().getDialect().useInputStreamToInsertBlob();
            if (bl) {
                preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setBlob(n, Hibernate.getLobCreator(sessionImplementor).createBlob(byArray));
            }
        }
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        node.setText(this.toString(object));
    }

    public String toString(Object object) {
        byte[] byArray = this.unWrap(object);
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] - -128);
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        return object == null ? "null" : this.toString(object);
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        String string = node.getText();
        return string == null || string.length() == 0 ? null : this.fromString(string);
    }

    private Object fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("The string is not a valid xml representation of a binary content.");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(i * 2, (i + 1) * 2);
            byArray[i] = (byte)(Integer.parseInt(string2, 16) + -128);
        }
        return this.wrap(byArray);
    }

    protected Object wrap(byte[] byArray) {
        return this.wrapPrimitive(byArray);
    }

    protected byte[] unWrap(Object object) {
        return this.unwrapNonPrimitive((Byte[])object);
    }

    private byte[] unwrapNonPrimitive(Byte[] byteArray) {
        int n = byteArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    private Byte[] wrapPrimitive(byte[] byArray) {
        int n = byArray.length;
        Byte[] byteArray = new Byte[n];
        for (int i = 0; i < n; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public boolean isMutable() {
        return true;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        if (this.isEqual(object, object2, sessionImplementor.getEntityMode())) {
            return object;
        }
        return this.deepCopy(object, sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return object == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }
}

