/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.LoggableUserType;
import org.hibernate.usertype.UserCollectionType;

public class CustomCollectionType
extends CollectionType {
    private final UserCollectionType userType;
    private final boolean customLogging;

    public CustomCollectionType(TypeFactory.TypeScope typeScope, Class clazz, String string, String string2, boolean bl) {
        super(typeScope, string, string2, bl);
        if (!UserCollectionType.class.isAssignableFrom(clazz)) {
            throw new MappingException("Custom type does not implement UserCollectionType: " + clazz.getName());
        }
        try {
            this.userType = (UserCollectionType)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new MappingException("Cannot instantiate custom type: " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MappingException("IllegalAccessException trying to instantiate custom type: " + clazz.getName());
        }
        this.customLogging = LoggableUserType.class.isAssignableFrom(clazz);
    }

    public PersistentCollection instantiate(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) throws HibernateException {
        return this.userType.instantiate(sessionImplementor, collectionPersister);
    }

    public PersistentCollection wrap(SessionImplementor sessionImplementor, Object object) {
        return this.userType.wrap(sessionImplementor, object);
    }

    public Class getReturnedClass() {
        return this.userType.instantiate(-1).getClass();
    }

    public Object instantiate(int n) {
        return this.userType.instantiate(n);
    }

    public Iterator getElementsIterator(Object object) {
        return this.userType.getElementsIterator(object);
    }

    public boolean contains(Object object, Object object2, SessionImplementor sessionImplementor) {
        return this.userType.contains(object, object2);
    }

    public Object indexOf(Object object, Object object2) {
        return this.userType.indexOf(object, object2);
    }

    public Object replaceElements(Object object, Object object2, Object object3, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        CollectionPersister collectionPersister = sessionImplementor.getFactory().getCollectionPersister(this.getRole());
        return this.userType.replaceElements(object, object2, collectionPersister, object3, map, sessionImplementor);
    }

    protected String renderLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (this.customLogging) {
            return ((LoggableUserType)((Object)this.userType)).toLoggableString(object, sessionFactoryImplementor);
        }
        return super.renderLoggableString(object, sessionFactoryImplementor);
    }

    public UserCollectionType getUserType() {
        return this.userType;
    }
}

