/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.type.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTimestampType
extends TimestampType {
    public static final DbTimestampType INSTANCE = new DbTimestampType();
    private static final Logger log = LoggerFactory.getLogger(DbTimestampType.class);

    public String getName() {
        return "dbtimestamp";
    }

    public String[] getRegistrationKeys() {
        return new String[]{this.getName()};
    }

    public Date seed(SessionImplementor sessionImplementor) {
        if (sessionImplementor == null) {
            log.trace("incoming session was null; using current jvm time");
            return super.seed(sessionImplementor);
        }
        if (!sessionImplementor.getFactory().getDialect().supportsCurrentTimestampSelection()) {
            log.debug("falling back to vm-based timestamp, as dialect does not support current timestamp selection");
            return super.seed(sessionImplementor);
        }
        return this.getCurrentTimestamp(sessionImplementor);
    }

    private Date getCurrentTimestamp(SessionImplementor sessionImplementor) {
        Dialect dialect = sessionImplementor.getFactory().getDialect();
        String string = dialect.getCurrentTimestampSelectString();
        if (dialect.isCurrentTimestampSelectStringCallable()) {
            return this.useCallableStatement(string, sessionImplementor);
        }
        return this.usePreparedStatement(string, sessionImplementor);
    }

    private Timestamp usePreparedStatement(String string, SessionImplementor sessionImplementor) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = sessionImplementor.getBatcher().prepareStatement(string);
            ResultSet resultSet = sessionImplementor.getBatcher().getResultSet(preparedStatement);
            resultSet.next();
            Timestamp timestamp = resultSet.getTimestamp(1);
            if (log.isTraceEnabled()) {
                log.trace("current timestamp retreived from db : " + timestamp + " (nanos=" + timestamp.getNanos() + ", time=" + timestamp.getTime() + ")");
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not select current db timestamp", string);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                }
                catch (SQLException sQLException) {
                    log.warn("unable to clean up prepared statement", sQLException);
                }
            }
        }
    }

    private Timestamp useCallableStatement(String string, SessionImplementor sessionImplementor) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = sessionImplementor.getBatcher().prepareCallableStatement(string);
            callableStatement.registerOutParameter(1, 93);
            callableStatement.execute();
            Timestamp timestamp = callableStatement.getTimestamp(1);
            if (log.isTraceEnabled()) {
                log.trace("current timestamp retreived from db : " + timestamp + " (nanos=" + timestamp.getNanos() + ", time=" + timestamp.getTime() + ")");
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not call current db timestamp function", string);
        }
        finally {
            if (callableStatement != null) {
                try {
                    sessionImplementor.getBatcher().closeStatement(callableStatement);
                }
                catch (SQLException sQLException) {
                    log.warn("unable to clean up callable statement", sQLException);
                }
            }
        }
    }
}

