/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

public abstract class EntityType
extends AbstractType
implements AssociationType {
    private final TypeFactory.TypeScope scope;
    private final String associatedEntityName;
    protected final String uniqueKeyPropertyName;
    protected final boolean isEmbeddedInXML;
    private final boolean eager;
    private final boolean unwrapProxy;
    private transient Class returnedClass;

    protected EntityType(TypeFactory.TypeScope typeScope, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.scope = typeScope;
        this.associatedEntityName = string;
        this.uniqueKeyPropertyName = string2;
        this.isEmbeddedInXML = bl2;
        this.eager = bl;
        this.unwrapProxy = bl3;
    }

    protected TypeFactory.TypeScope scope() {
        return this.scope;
    }

    public boolean isAssociationType() {
        return true;
    }

    public final boolean isEntityType() {
        return true;
    }

    public boolean isMutable() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getAssociatedEntityName() + ')';
    }

    public String getName() {
        return this.associatedEntityName;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.uniqueKeyPropertyName == null;
    }

    public String getRHSUniqueKeyPropertyName() {
        return this.uniqueKeyPropertyName;
    }

    public String getLHSPropertyName() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public final String getAssociatedEntityName() {
        return this.associatedEntityName;
    }

    public String getAssociatedEntityName(SessionFactoryImplementor sessionFactoryImplementor) {
        return this.getAssociatedEntityName();
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        return (Joinable)((Object)sessionFactoryImplementor.getEntityPersister(this.associatedEntityName));
    }

    public final Class getReturnedClass() {
        if (this.returnedClass == null) {
            this.returnedClass = this.determineAssociatedEntityClass();
        }
        return this.returnedClass;
    }

    private Class determineAssociatedEntityClass() {
        try {
            return ReflectHelper.classForName(this.getAssociatedEntityName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Map.class;
        }
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, new String[]{string}, sessionImplementor, object);
    }

    public final Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(resultSet, stringArray, sessionImplementor, object), sessionImplementor, object);
    }

    public final boolean isSame(Object object, Object object2, EntityMode entityMode) {
        return object == object2;
    }

    public int compare(Object object, Object object2, EntityMode entityMode) {
        return 0;
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        return object;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object v = map.get(object);
        if (v != null) {
            return v;
        }
        if (object == object2) {
            return object2;
        }
        if (sessionImplementor.getContextEntityIdentifier(object) == null && ForeignKeys.isTransient(this.associatedEntityName, object, Boolean.FALSE, sessionImplementor)) {
            Object object4 = sessionImplementor.getFactory().getEntityPersister(this.associatedEntityName).instantiate(null, sessionImplementor);
            map.put(object, object4);
            return object4;
        }
        Object object5 = this.getIdentifier(object, sessionImplementor);
        if (object5 == null) {
            throw new AssertionFailure("non-transient entity has a null id");
        }
        object5 = this.getIdentifierOrUniqueKeyType(sessionImplementor.getFactory()).replace(object5, null, sessionImplementor, object3, map);
        return this.resolve(object5, sessionImplementor, object3);
    }

    public int getHashCode(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        Class clazz;
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(this.associatedEntityName);
        if (!entityPersister.canExtractIdOutOfEntity()) {
            return super.getHashCode(object, entityMode);
        }
        Serializable serializable = object instanceof HibernateProxy ? ((HibernateProxy)object).getHibernateLazyInitializer().getIdentifier() : ((clazz = entityPersister.getMappedClass(entityMode)).isAssignableFrom(object.getClass()) ? entityPersister.getIdentifier(object, entityMode) : (Serializable)object);
        return entityPersister.getIdentifierType().getHashCode(serializable, entityMode, sessionFactoryImplementor);
    }

    public boolean isEqual(Object object, Object object2, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(this.associatedEntityName);
        if (!entityPersister.canExtractIdOutOfEntity()) {
            return super.isEqual(object, object2, entityMode);
        }
        Class clazz = entityPersister.getMappedClass(entityMode);
        Serializable serializable = object instanceof HibernateProxy ? ((HibernateProxy)object).getHibernateLazyInitializer().getIdentifier() : (clazz.isAssignableFrom(object.getClass()) ? entityPersister.getIdentifier(object, entityMode) : (Serializable)object);
        Serializable serializable2 = object2 instanceof HibernateProxy ? ((HibernateProxy)object2).getHibernateLazyInitializer().getIdentifier() : (clazz.isAssignableFrom(object2.getClass()) ? entityPersister.getIdentifier(object2, entityMode) : (Serializable)object2);
        return entityPersister.getIdentifierType().isEqual(serializable, serializable2, entityMode, sessionFactoryImplementor);
    }

    public boolean isEmbeddedInXML() {
        return this.isEmbeddedInXML;
    }

    public boolean isXMLElement() {
        return this.isEmbeddedInXML;
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            return this.getIdentifierType(mapping).fromXMLNode(node, mapping);
        }
        return node;
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            this.getIdentifierType(sessionFactoryImplementor).setToXMLNode(node, object, sessionFactoryImplementor);
        } else {
            Element element = (Element)object;
            EntityType.replaceNode(node, new ElementWrapper(element));
        }
    }

    public String getOnCondition(String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return "";
        }
        return this.getAssociatedJoinable(sessionFactoryImplementor).filterFragment(string, map);
    }

    public Object resolve(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        if (this.isNotEmbedded(sessionImplementor)) {
            return object;
        }
        if (object == null) {
            return null;
        }
        if (this.isNull(object2, sessionImplementor)) {
            return null;
        }
        if (this.isReferenceToPrimaryKey()) {
            return this.resolveIdentifier((Serializable)object, sessionImplementor);
        }
        return this.loadByUniqueKey(this.getAssociatedEntityName(), this.uniqueKeyPropertyName, object, sessionImplementor);
    }

    public Type getSemiResolvedType(SessionFactoryImplementor sessionFactoryImplementor) {
        return sessionFactoryImplementor.getEntityPersister(this.associatedEntityName).getIdentifierType();
    }

    protected final Object getIdentifier(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.isNotEmbedded(sessionImplementor)) {
            return object;
        }
        if (this.isReferenceToPrimaryKey()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), object, sessionImplementor);
        }
        if (object == null) {
            return null;
        }
        EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(this.getAssociatedEntityName());
        Object object2 = entityPersister.getPropertyValue(object, this.uniqueKeyPropertyName, sessionImplementor.getEntityMode());
        Type type = entityPersister.getPropertyType(this.uniqueKeyPropertyName);
        if (type.isEntityType()) {
            object2 = ((EntityType)type).getIdentifier(object2, sessionImplementor);
        }
        return object2;
    }

    protected boolean isNotEmbedded(SessionImplementor sessionImplementor) {
        return !this.isEmbeddedInXML && sessionImplementor.getEntityMode() == EntityMode.DOM4J;
    }

    private static Serializable getIdentifier(Object object, EntityPersister entityPersister, EntityMode entityMode) {
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            return lazyInitializer.getIdentifier();
        }
        return entityPersister.getIdentifier(object, entityMode);
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        if (object == null) {
            return "null";
        }
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(this.associatedEntityName);
        StringBuffer stringBuffer = new StringBuffer().append(this.associatedEntityName);
        if (entityPersister.hasIdentifierProperty()) {
            Serializable serializable;
            EntityMode entityMode = entityPersister.guessEntityMode(object);
            if (entityMode == null) {
                if (this.isEmbeddedInXML) {
                    throw new ClassCastException(object.getClass().getName());
                }
                serializable = (Serializable)object;
            } else {
                serializable = EntityType.getIdentifier(object, entityPersister, entityMode);
            }
            stringBuffer.append('#').append(entityPersister.getIdentifierType().toLoggableString(serializable, sessionFactoryImplementor));
        }
        return stringBuffer.toString();
    }

    public abstract boolean isOneToOne();

    public boolean isLogicalOneToOne() {
        return this.isOneToOne();
    }

    Type getIdentifierType(Mapping mapping) {
        return mapping.getIdentifierType(this.getAssociatedEntityName());
    }

    Type getIdentifierType(SessionImplementor sessionImplementor) {
        return this.getIdentifierType(sessionImplementor.getFactory());
    }

    public final Type getIdentifierOrUniqueKeyType(Mapping mapping) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return this.getIdentifierType(mapping);
        }
        Type type = mapping.getReferencedPropertyType(this.getAssociatedEntityName(), this.uniqueKeyPropertyName);
        if (type.isEntityType()) {
            type = ((EntityType)type).getIdentifierOrUniqueKeyType(mapping);
        }
        return type;
    }

    public final String getIdentifierOrUniqueKeyPropertyName(Mapping mapping) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return mapping.getIdentifierPropertyName(this.getAssociatedEntityName());
        }
        return this.uniqueKeyPropertyName;
    }

    protected abstract boolean isNullable();

    protected final Object resolveIdentifier(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl = this.unwrapProxy && sessionImplementor.getFactory().getEntityPersister(this.getAssociatedEntityName()).isInstrumented(sessionImplementor.getEntityMode());
        Object object = sessionImplementor.internalLoad(this.getAssociatedEntityName(), serializable, this.eager, this.isNullable() && !bl);
        if (object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setUnwrap(bl);
        }
        return object;
    }

    protected boolean isNull(Object object, SessionImplementor sessionImplementor) {
        return false;
    }

    public Object loadByUniqueKey(String string, String string2, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        UniqueKeyLoadable uniqueKeyLoadable = (UniqueKeyLoadable)sessionFactoryImplementor.getEntityPersister(string);
        EntityUniqueKey entityUniqueKey = new EntityUniqueKey(string, string2, object, this.getIdentifierOrUniqueKeyType(sessionFactoryImplementor), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        Object object2 = persistenceContext.getEntity(entityUniqueKey);
        if (object2 == null) {
            object2 = uniqueKeyLoadable.loadByUniqueKey(string2, object, sessionImplementor);
        }
        return object2 == null ? null : persistenceContext.proxyFor(object2);
    }
}

