/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumType
implements EnhancedUserType,
ParameterizedType,
Serializable {
    private static final boolean IS_VALUE_TRACING_ENABLED = LoggerFactory.getLogger(StringHelper.qualifier(Type.class.getName())).isTraceEnabled();
    private transient Logger log;
    public static final String ENUM = "enumClass";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    private Class<? extends Enum> enumClass;
    private transient Object[] enumValues;
    private int sqlType = 4;

    private Logger log() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(this.getClass());
        }
        return this.log;
    }

    @Override
    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    @Override
    public Class<? extends Enum> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object object, Object object2) throws HibernateException {
        return object == object2;
    }

    @Override
    public int hashCode(Object object) throws HibernateException {
        return object == null ? 0 : object.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, Object object) throws HibernateException, SQLException {
        Object object2 = resultSet.getObject(stringArray[0]);
        if (resultSet.wasNull()) {
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().debug("Returning null as column {}", (Object)stringArray[0]);
            }
            return null;
        }
        if (object2 instanceof Number) {
            this.initEnumValues();
            int n = ((Number)object2).intValue();
            if (n < 0 || n >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + n);
            }
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().debug("Returning '{}' as column {}", n, (Object)stringArray[0]);
            }
            return this.enumValues[n];
        }
        String string = (String)object2;
        if (IS_VALUE_TRACING_ENABLED) {
            this.log().debug("Returning '{}' as column {}", (Object)string, (Object)stringArray[0]);
        }
        try {
            return Enum.valueOf(this.enumClass, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + string, illegalArgumentException);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        if (object == null) {
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().debug("Binding null to parameter: {}", n);
            }
            preparedStatement.setNull(n, this.sqlType);
        } else {
            boolean bl = this.isOrdinal(this.sqlType);
            if (bl) {
                int n2 = ((Enum)object).ordinal();
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().debug("Binding '{}' to parameter: {}", n2, (Object)n);
                }
                preparedStatement.setObject(n, (Object)n2, this.sqlType);
            } else {
                String string = ((Enum)object).name();
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().debug("Binding '{}' to parameter: {}", (Object)string, (Object)n);
                }
                preparedStatement.setObject(n, (Object)string, this.sqlType);
            }
        }
    }

    private boolean isOrdinal(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + n);
    }

    @Override
    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object object) throws HibernateException {
        return (Serializable)object;
    }

    @Override
    public Object assemble(Serializable serializable, Object object) throws HibernateException {
        return serializable;
    }

    @Override
    public Object replace(Object object, Object object2, Object object3) throws HibernateException {
        return object;
    }

    @Override
    public void setParameterValues(Properties properties) {
        String string = properties.getProperty(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName(string, this.getClass()).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Enum class not found", classNotFoundException);
        }
        String string2 = properties.getProperty(TYPE);
        if (string2 != null) {
            this.sqlType = Integer.decode(string2);
        }
    }

    private void initEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.enumClass.getEnumConstants();
            if (this.enumValues == null) {
                throw new NullPointerException("Failed to init enumValues");
            }
        }
    }

    @Override
    public String objectToSQLString(Object object) {
        boolean bl = this.isOrdinal(this.sqlType);
        if (bl) {
            int n = ((Enum)object).ordinal();
            return Integer.toString(n);
        }
        return '\'' + ((Enum)object).name() + '\'';
    }

    @Override
    public String toXMLString(Object object) {
        boolean bl = this.isOrdinal(this.sqlType);
        if (bl) {
            int n = ((Enum)object).ordinal();
            return Integer.toString(n);
        }
        return ((Enum)object).name();
    }

    @Override
    public Object fromXMLString(String string) {
        try {
            int n = Integer.parseInt(string);
            this.initEnumValues();
            if (n < 0 || n >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + n);
            }
            return this.enumValues[n];
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Enum.valueOf(this.enumClass, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + string, illegalArgumentException);
            }
        }
    }
}

