/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class OneToOneType
extends EntityType {
    private final ForeignKeyDirection foreignKeyType;
    private final String propertyName;
    private final String entityName;

    public OneToOneType(TypeFactory.TypeScope typeScope, String string, ForeignKeyDirection foreignKeyDirection, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4) {
        super(typeScope, string, string2, !bl, bl3, bl2);
        this.foreignKeyType = foreignKeyDirection;
        this.propertyName = string4;
        this.entityName = string3;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isNull(Object object, SessionImplementor sessionImplementor) {
        if (this.propertyName != null) {
            EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(this.entityName);
            Serializable serializable = sessionImplementor.getContextEntityIdentifier(object);
            EntityKey entityKey = new EntityKey(serializable, entityPersister, sessionImplementor.getEntityMode());
            return sessionImplementor.getPersistenceContext().isPropertyNull(entityKey, this.getPropertyName());
        }
        return false;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return 0;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) {
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) {
    }

    public boolean isOneToOne() {
        return true;
    }

    public boolean isDirty(Object object, Object object2, SessionImplementor sessionImplementor) {
        return false;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) {
        return false;
    }

    public boolean isModified(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) {
        return false;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return this.foreignKeyType;
    }

    public Object hydrate(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return sessionImplementor.getContextEntityIdentifier(object);
    }

    protected boolean isNullable() {
        return this.foreignKeyType == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT;
    }

    public boolean useLHSPrimaryKey() {
        return true;
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        return null;
    }

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.resolve(sessionImplementor.getContextEntityIdentifier(object), sessionImplementor, object);
    }

    public boolean isAlwaysDirtyChecked() {
        return false;
    }
}

