/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractLobType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SerializationHelper;

public class SerializableToBlobType
extends AbstractLobType
implements ParameterizedType {
    public static final String CLASS_NAME = "classname";
    private Class serializableClass;
    private SerializableType type;

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2004};
    }

    public Class getReturnedClass() {
        return this.serializableClass;
    }

    public boolean isEqual(Object object, Object object2, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.type.isEqual(object, object2);
    }

    public int getHashCode(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.type.getHashCode(object, null);
    }

    public Object get(ResultSet resultSet, String string) throws SQLException {
        Blob blob = resultSet.getBlob(string);
        if (resultSet.wasNull()) {
            return null;
        }
        int n = (int)blob.length();
        byte[] byArray = blob.getBytes(1L, n);
        return this.fromBytes(byArray);
    }

    private static byte[] toBytes(Object object) throws SerializationException {
        return SerializationHelper.serialize((Serializable)object);
    }

    private Object fromBytes(byte[] byArray) throws SerializationException {
        return SerializationHelper.deserialize(byArray, this.getReturnedClass().getClassLoader());
    }

    public void set(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws SQLException {
        if (object != null) {
            byte[] byArray = SerializableToBlobType.toBytes(object);
            if (sessionImplementor.getFactory().getDialect().useInputStreamToInsertBlob()) {
                preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setBlob(n, Hibernate.getLobCreator(sessionImplementor).createBlob(byArray));
            }
        } else {
            preparedStatement.setNull(n, this.sqlTypes(null)[0]);
        }
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        this.type.setToXMLNode(node, object, sessionFactoryImplementor);
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return this.type.toLoggableString(object, sessionFactoryImplementor);
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return this.type.fromXMLNode(node, mapping);
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return this.type.deepCopy(object, null, null);
    }

    public boolean isMutable() {
        return this.type.isMutable();
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        return this.type.replace(object, object2, sessionImplementor, object3, map);
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return this.type.toColumnNullness(object, mapping);
    }

    public void setParameterValues(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty(CLASS_NAME);
            if (string == null) {
                throw new MappingException("No class name defined for type: " + SerializableToBlobType.class.getName());
            }
            try {
                this.serializableClass = ReflectHelper.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MappingException("Unable to load class from classname parameter", classNotFoundException);
            }
        }
        this.type = new SerializableType(this.serializableClass);
    }
}

