/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentElementHolder;
import org.hibernate.collection.PersistentMapElementHolder;
import org.hibernate.collection.PersistentSortedMap;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.MapType;
import org.hibernate.type.TypeFactory;

public class SortedMapType
extends MapType {
    private final Comparator comparator;

    public SortedMapType(TypeFactory.TypeScope typeScope, String string, String string2, Comparator comparator, boolean bl) {
        super(typeScope, string, string2, bl);
        this.comparator = comparator;
    }

    public PersistentCollection instantiate(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) {
        if (sessionImplementor.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentMapElementHolder(sessionImplementor, collectionPersister, serializable);
        }
        PersistentSortedMap persistentSortedMap = new PersistentSortedMap(sessionImplementor);
        persistentSortedMap.setComparator(this.comparator);
        return persistentSortedMap;
    }

    public Class getReturnedClass() {
        return SortedMap.class;
    }

    public Object instantiate(int n) {
        return new TreeMap(this.comparator);
    }

    public PersistentCollection wrap(SessionImplementor sessionImplementor, Object object) {
        if (sessionImplementor.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentElementHolder(sessionImplementor, (Element)object);
        }
        return new PersistentSortedMap(sessionImplementor, (SortedMap)object);
    }
}

