/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentElementHolder;
import org.hibernate.collection.PersistentSortedSet;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.SetType;
import org.hibernate.type.TypeFactory;

public class SortedSetType
extends SetType {
    private final Comparator comparator;

    public SortedSetType(TypeFactory.TypeScope typeScope, String string, String string2, Comparator comparator, boolean bl) {
        super(typeScope, string, string2, bl);
        this.comparator = comparator;
    }

    public PersistentCollection instantiate(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) {
        if (sessionImplementor.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentElementHolder(sessionImplementor, collectionPersister, serializable);
        }
        PersistentSortedSet persistentSortedSet = new PersistentSortedSet(sessionImplementor);
        persistentSortedSet.setComparator(this.comparator);
        return persistentSortedSet;
    }

    public Class getReturnedClass() {
        return SortedSet.class;
    }

    public Object instantiate(int n) {
        return new TreeSet(this.comparator);
    }

    public PersistentCollection wrap(SessionImplementor sessionImplementor, Object object) {
        if (sessionImplementor.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentElementHolder(sessionImplementor, (Element)object);
        }
        return new PersistentSortedSet(sessionImplementor, (SortedSet)object);
    }
}

