/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanTypeDescriptor
extends AbstractTypeDescriptor<Boolean> {
    public static final BooleanTypeDescriptor INSTANCE = new BooleanTypeDescriptor();
    private final char characterValueTrue;
    private final char characterValueFalse;
    private final char characterValueTrueLC;
    private final String stringValueTrue;
    private final String stringValueFalse;

    public BooleanTypeDescriptor() {
        this('Y', 'N');
    }

    public BooleanTypeDescriptor(char c, char c2) {
        super(Boolean.class);
        this.characterValueTrue = Character.toUpperCase(c);
        this.characterValueFalse = Character.toUpperCase(c2);
        this.characterValueTrueLC = Character.toLowerCase(c);
        this.stringValueTrue = String.valueOf(c);
        this.stringValueFalse = String.valueOf(c2);
    }

    @Override
    public String toString(Boolean bl) {
        return bl == null ? null : bl.toString();
    }

    @Override
    public Boolean fromString(String string) {
        return Boolean.valueOf(string);
    }

    @Override
    public <X> X unwrap(Boolean bl, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (bl == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return (X)bl;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)this.toByte(bl);
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)this.toShort(bl);
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)this.toInteger(bl);
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)this.toInteger(bl);
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return (X)Character.valueOf(bl != false ? this.characterValueTrue : this.characterValueFalse);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)(bl != false ? this.stringValueTrue : this.stringValueFalse);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Boolean wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Boolean.class.isInstance(x)) {
            return (Boolean)x;
        }
        if (Number.class.isInstance(x)) {
            int n = ((Number)x).intValue();
            return n == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (Character.class.isInstance(x)) {
            return this.isTrue(((Character)x).charValue()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (String.class.isInstance(x)) {
            return this.isTrue(((String)x).charAt(0)) ? Boolean.TRUE : Boolean.FALSE;
        }
        throw this.unknownWrap(x.getClass());
    }

    private boolean isTrue(char c) {
        return c == this.characterValueTrue || c == this.characterValueTrueLC;
    }

    public int toInt(Boolean bl) {
        return bl != false ? 1 : 0;
    }

    public Byte toByte(Boolean bl) {
        return (byte)this.toInt(bl);
    }

    public Short toShort(Boolean bl) {
        return (short)this.toInt(bl);
    }

    public Integer toInteger(Boolean bl) {
        return this.toInt(bl);
    }

    public Long toLong(Boolean bl) {
        return this.toInt(bl);
    }
}

